<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

final class CreateInsideSessionsTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('inside_sessions')) {
            return;
        }

        Schema::create('inside_sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->uuid('user_id')->index();
            $table->ipAddress('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->text('payload');
            $table->integer('last_activity');
        });
    }
}
