<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class CreateInsideSessionLifetimeSettingValues extends Migration
{
    public function up(): void
    {
        Setting::updateOrCreate(
            ['key' => 'inside_session_lifetime', 'group' => 'loginpage'],
            ['value' => intval(config('session.lifetime'))]
        );

        Setting::updateOrCreate(
            ['key' => 'inside_session_longer_lifetime', 'group' => 'loginpage'],
            ['value' => intval(config('session.longer_lifetime'))]
        );

        Setting::updateOrCreate(
            ['key' => 'inside_session_sso_lifetime', 'group' => 'loginpage'],
            ['value' => intval(config('session.sso_lifetime'))]
        );

        Setting::updateOrCreate(
            ['key' => 'remember_me_enabled', 'group' => 'loginpage'],
            ['value' => true]
        );
    }

    public function down(): void
    {
        Setting::where(['key' => 'inside_session_lifetime', 'group' => 'loginpage'])->delete();
        Setting::where(['key' => 'inside_session_longer_lifetime', 'group' => 'loginpage'])->delete();
        Setting::where(['key' => 'inside_session_sso_lifetime', 'group' => 'loginpage'])->delete();
        Setting::where(['key' => 'remember_me_enabled', 'group' => 'loginpage'])->delete();
    }
}
