<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Authentication\Models\User;
use Inside\Facades\Package;
use Inside\Statistics\Models\Statistic;

class AddLastLoginAtColumn extends Migration
{
    public function up(): void
    {
        Schema::table('inside_users', function (Blueprint $table) {
            $table->datetime('last_login_at')->nullable()->before('created_at')->index();
        });

        // Retrocompat
        User::each(function ($user) {
            if (Package::has('inside-stats')) {
                // Use stats
                $lastConnection =
                    Statistic::where('type', 'authentication')->where('user_uuid', $user->uuid)->orderByDesc(
                        'created_at'
                    )->first();

                if ($lastConnection !== null) {
                    $user->update(['last_login_at' => $lastConnection->created_at]);
                }

                return;
            }
            $lastToken =
                $user->tokens()->where('authenticator', '<>', 'inside-admin')->orderByDesc('last_used_at')->first();
            if ($lastToken !== null) {
                $user->update(['last_login_at' => $lastToken->created_at]);
            }
        });
    }

    public function down(): void
    {
        Schema::table('inside_users', function (Blueprint $table) {
            $table->dropColumn('last_login_at');
        });
    }
}
