<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

class CreateApplicationClientsTable extends Migration
{
    public function up(): void
    {
        Schema::create(
            'inside_application_clients',
            function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('name');
                $table->string('secret', 100)->nullable();
                $table->timestamps();
            }
        );
        DB::table('inside_application_clients')->insert(
            [
                'name'   => 'monitoring',
                'secret' => Str::random(40),
            ]
        );
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_application_clients');
    }
}
