<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInsideAuthenticationTokensTable extends Migration
{
    public function up(): void
    {
        Schema::create('inside_authentication_tokens', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('authenticator');
            $table->uuid('user_uuid')->collate('utf8');
            $table->string('token', 64)->unique();
            $table->timestamp('last_used_at')->nullable();
            $table->text('abilities')->nullable();
            $table->text('device')->nullable();
            $table->string('last_login_ip')->nullable();
            $table->timestamps();
        });

        Schema::table('inside_authentication_tokens', function (Blueprint $table) {
            $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
        });

        Schema::table('inside_users', function (Blueprint $table) {
            $table->dropColumn('api_token');
            $table->dropColumn('last_login_at');
            $table->dropColumn('last_login_ip');
        });
    }

    public function down(): void
    {
        Schema::table('inside_users', function (Blueprint $table) {
            $table->string('api_token', 60)->nullable()->unique();
            $table->datetime('last_login_at')->nullable();
            $table->string('last_login_ip')->nullable();
        });

        Schema::table('inside_authentication_tokens', function (Blueprint $table) {
            $table->dropForeign('inside_authentication_tokens_user_uuid_foreign');
        });
        Schema::drop('inside_authentication_tokens');
    }
}
