<?php

namespace Inside\Ai\Providers;

use Inside\Ai\Contracts\AIProviderContract;
use Inside\Ai\Contracts\TextProcessorContract;
use Inside\Ai\Services\Providers\AzureOpenAIProvider;
use Inside\Ai\Services\Providers\OpenAIProvider;
use Inside\Ai\Services\TextProcessor;
use Inside\Providers\ServiceProvider as BaseServiceProvider;

class AiServiceProvider extends BaseServiceProvider
{
    public function boot(): void
    {
        $this->app->singleton(AIProviderContract::class, function () {
            $provider = config('ai.default_provider', 'openai');
            return match ($provider) {
                'openai' => new OpenAIProvider(
                    apiKey: config('ai.providers.openai.token'),
                    apiUrl: config('ai.providers.openai.api_url'),
                    models: config('ai.providers.openai.models', []),
                    defaultModel: config('ai.providers.openai.default_model')
                ),
                'azure_openai' => new AzureOpenAIProvider(
                    apiKey: config('ai.providers.azure_openai.token'),
                    apiUrl: config('ai.providers.azure_openai.api_url'),
                    deploymentName: config('ai.providers.azure_openai.deployment_name'),
                )
            };
        });

        // Bind Text Processor
        $this->app->singleton(TextProcessorContract::class, fn($app)  => new TextProcessor(
            availableActions: array_keys(config('ai.prompts.actions', [])),
            aiProvider: $app->make(AIProviderContract::class)
        ));

        $this->mergeConfigTo(__DIR__.'/../../config/ai.php', 'ai');
    }
}
