<?php

namespace Inside\Ai\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Ai\Contracts\TextProcessorContract;
use Inside\Ai\Http\Requests\ProcessTextRequest;

class AIController
{
    public function __construct(
        private TextProcessorContract  $textProcessor
    ) {
    }

    /**
     * Process text with AI
     */
    public function processText(ProcessTextRequest $request): JsonResponse
    {
        $result = $this->textProcessor->processText(
            text: $request->validated('text'),
            action: $request->validated('action'),
            user: $request->user()
        );

        return response()->json([
            'success' => $result->success,
            'data' => $result->toArray()
        ], $result->success ? 200 : 422);
    }

    /**
     * Get AI configuration info (non-sensitive)
     */
    public function getConfig(): JsonResponse
    {
        $provider = config('ai.default_provider');
        $providerSettings = config("ai.providers.{$provider}.settings", []) ;

        $data = [
            'success' => true,
            'data' => [
                'providers' => config('ai.providers'),
                'default_provider' => $provider,
                'prompts' => config('ai.prompts', [])
            ]
        ];
        foreach ($data['data']['providers'] as $provider => $settings) {
            $data['data']['providers'][$provider]['token'] = sprintf('%s********%s', str($settings['token'])->substr(0, 3), str($settings['token'])->substr(-3));
        }
        array_merge($data['data'], $providerSettings);
        return response()->json($data);
    }
}
