/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

public class Levenshtein {
    private static int minimum(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    public static int distance(String s2, String t2) {
        int j;
        int i;
        int n = s2.length();
        int m4 = t2.length();
        if (n == 0) {
            return m4;
        }
        if (m4 == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m4 + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m4; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s2.charAt(i - 1);
            for (j = 1; j <= m4; ++j) {
                char t_j = t2.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = Levenshtein.minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m4];
    }
}

