/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xmp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.jempbox.xmp.ResourceEvent;
import org.apache.jempbox.xmp.ResourceRef;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.XMPSchemaMediaManagement;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPMM;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.xmp.XMPPacketScanner;
import org.apache.tika.utils.DateUtils;
import org.apache.tika.utils.XMLReaderUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JempboxExtractor {
    private static final ParseContext EMPTY_PARSE_CONTEXT = new ParseContext();
    private static final String DEFAULT_XMP_CHARSET = StandardCharsets.UTF_8.name();
    private static volatile int MAX_EVENT_HISTORY_IN_XMPMM = 1024;
    private XMPPacketScanner scanner = new XMPPacketScanner();
    private Metadata metadata;

    public JempboxExtractor(Metadata metadata) {
        this.metadata = metadata;
    }

    public static void extractDublinCore(XMPMetadata xmpMetadata, Metadata metadata) {
        if (xmpMetadata == null) {
            return;
        }
        XMPSchemaDublinCore dc = null;
        try {
            dc = xmpMetadata.getDublinCoreSchema();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (dc == null) {
            return;
        }
        if (dc.getTitle() != null) {
            metadata.set(TikaCoreProperties.TITLE, dc.getTitle());
        }
        if (dc.getDescription() != null) {
            metadata.set(TikaCoreProperties.DESCRIPTION, dc.getDescription());
        }
        if (dc.getCreators() != null && dc.getCreators().size() > 0) {
            metadata.set(TikaCoreProperties.CREATOR, JempboxExtractor.joinCreators(dc.getCreators()));
        }
        if (dc.getSubjects() != null && dc.getSubjects().size() > 0) {
            for (String keyword : dc.getSubjects()) {
                metadata.add(TikaCoreProperties.SUBJECT, keyword);
            }
        }
    }

    protected static String joinCreators(List<String> creators) {
        if (creators == null || creators.size() == 0) {
            return "";
        }
        if (creators.size() == 1) {
            return creators.get(0);
        }
        StringBuffer c = new StringBuffer();
        for (String s2 : creators) {
            c.append(", ").append(s2);
        }
        return c.substring(2);
    }

    public static void extractXMPMM(XMPMetadata xmp, Metadata metadata) {
        if (xmp == null) {
            return;
        }
        XMPSchemaMediaManagement mmSchema = null;
        try {
            mmSchema = xmp.getMediaManagementSchema();
        }
        catch (IOException e) {
            return;
        }
        if (mmSchema != null) {
            JempboxExtractor.addMetadata(metadata, XMPMM.DOCUMENTID, mmSchema.getDocumentID());
            ResourceRef derivedFrom = mmSchema.getDerivedFrom();
            if (derivedFrom != null) {
                try {
                    JempboxExtractor.addMetadata(metadata, XMPMM.DERIVED_FROM_DOCUMENTID, derivedFrom.getDocumentID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    JempboxExtractor.addMetadata(metadata, XMPMM.DERIVED_FROM_INSTANCEID, derivedFrom.getInstanceID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (mmSchema.getHistory() != null) {
                int eventsAdded = 0;
                for (ResourceEvent stevt : mmSchema.getHistory()) {
                    if (eventsAdded >= MAX_EVENT_HISTORY_IN_XMPMM) break;
                    String instanceId = null;
                    String action = null;
                    Calendar when = null;
                    String softwareAgent = null;
                    try {
                        instanceId = stevt.getInstanceID();
                        action = stevt.getAction();
                        when = stevt.getWhen();
                        softwareAgent = stevt.getSoftwareAgent();
                    }
                    catch (IOException | NullPointerException exception) {
                        // empty catch block
                    }
                    if (instanceId == null || instanceId.trim().length() <= 0) continue;
                    action = action == null ? "" : action;
                    String dateString = when == null ? "" : DateUtils.formatDate(when);
                    softwareAgent = softwareAgent == null ? "" : softwareAgent;
                    metadata.add(XMPMM.HISTORY_EVENT_INSTANCEID, instanceId);
                    metadata.add(XMPMM.HISTORY_ACTION, action);
                    metadata.add(XMPMM.HISTORY_WHEN, dateString);
                    metadata.add(XMPMM.HISTORY_SOFTWARE_AGENT, softwareAgent);
                    ++eventsAdded;
                }
            }
        }
    }

    private static void addMetadata(Metadata m4, Property p, String value) {
        if (value != null && (p.isMultiValuePermitted() || m4.get(p) == null)) {
            m4.add(p, value);
        }
    }

    public static int getMaxXMPMMHistory() {
        return MAX_EVENT_HISTORY_IN_XMPMM;
    }

    public static void setMaxXMPMMHistory(int maxEvents) {
        MAX_EVENT_HISTORY_IN_XMPMM = maxEvents;
    }

    public void parse(InputStream file) throws IOException, TikaException {
        UnsynchronizedByteArrayOutputStream xmpraw = new UnsynchronizedByteArrayOutputStream();
        if (!this.scanner.parse(file, xmpraw)) {
            return;
        }
        XMPMetadata xmp = null;
        try (InputStream decoded = xmpraw.toInputStream();){
            Document dom = XMLReaderUtils.buildDOM(decoded, EMPTY_PARSE_CONTEXT);
            if (dom != null) {
                xmp = new XMPMetadata(dom);
            }
        }
        catch (IOException | SAXException exception) {
            // empty catch block
        }
        JempboxExtractor.extractDublinCore(xmp, this.metadata);
        JempboxExtractor.extractXMPMM(xmp, this.metadata);
    }
}

