/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xps;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XPSPageContentHandler
extends DefaultHandler {
    private static final String GLYPHS = "Glyphs";
    private static final String CANVAS = "Canvas";
    private static final String CLIP = "Clip";
    private static final String NULL_CLIP = "NULL_CLIP";
    private static final String UNICODE_STRING = "UnicodeString";
    private static final String ORIGIN_X = "OriginX";
    private static final String ORIGIN_Y = "OriginY";
    private static final String BIDI_LEVEL = "BidiLevel";
    private static final String INDICES = "Indices";
    private static final String NAME = "Name";
    private static final String PATH = "Path";
    private static final String NAVIGATE_URI = "FixedPage.NavigateUri";
    private static final String IMAGE_SOURCE = "ImageSource";
    private static final String IMAGE_BRUSH = "ImageBrush";
    private static final String AUTOMATION_PROPERITES_HELP_TEXT = "AutomationProperties.HelpText";
    private static final String URL_DIV = "urls";
    private static final String DIV = "div";
    private static final String CLASS = "class";
    private static final String PAGE = "page";
    private static final String CANVAS_SAX = "canvas";
    private static final String P = "p";
    private static final String HREF = "href";
    private static final String A = "a";
    private static Comparator<? super List<GlyphRun>> ROW_SORTER = (o1, o2) -> {
        if (((GlyphRun)o1.get(0)).originY < ((GlyphRun)o2.get(0)).originY) {
            return -1;
        }
        if (((GlyphRun)o1.get(0)).originY > ((GlyphRun)o2.get(0)).originY) {
            return 1;
        }
        return 0;
    };
    private final XHTMLContentHandler xhml;
    private final Map<String, Metadata> embeddedInfos;
    private String imageSourcePathInZip = null;
    private String originalLocationOnDrive = null;
    private Map<String, List<GlyphRun>> canvases = new LinkedHashMap<String, List<GlyphRun>>();
    private Set<String> urls = new LinkedHashSet<String>();
    private Stack<String> canvasStack = new Stack();

    public XPSPageContentHandler(XHTMLContentHandler xhtml, Map<String, Metadata> embeddedInfos) {
        this.xhml = xhtml;
        this.embeddedInfos = embeddedInfos;
    }

    private static String getVal(String localName, Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!localName.equals(atts.getLocalName(i))) continue;
            return atts.getValue(i);
        }
        return null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (CANVAS.equals(localName)) {
            String clip = XPSPageContentHandler.getVal(CLIP, atts);
            if (clip == null) {
                this.canvasStack.push(NULL_CLIP);
            } else {
                this.canvasStack.push(clip);
            }
            return;
        }
        if (PATH.equals(localName)) {
            String url = XPSPageContentHandler.getVal(NAVIGATE_URI, atts);
            if (url != null) {
                this.urls.add(url);
            }
            this.originalLocationOnDrive = XPSPageContentHandler.getVal(AUTOMATION_PROPERITES_HELP_TEXT, atts);
        } else if (IMAGE_BRUSH.equals(localName)) {
            this.imageSourcePathInZip = XPSPageContentHandler.getVal(IMAGE_SOURCE, atts);
        }
        if (!GLYPHS.equals(localName)) {
            return;
        }
        String name = null;
        Float originX = null;
        Float originY = null;
        String unicodeString = null;
        int bidilevel = 1;
        String indicesString = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            String lName = atts.getLocalName(i);
            String value = atts.getValue(i);
            String string = value = value == null ? "" : value.trim();
            if (ORIGIN_X.equals(lName) && value.length() > 0) {
                try {
                    originX = Float.valueOf(Float.parseFloat(atts.getValue(i)));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
            }
            if (ORIGIN_Y.equals(lName) && value.length() > 0) {
                try {
                    originY = Float.valueOf(Float.parseFloat(atts.getValue(i)));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
            }
            if (UNICODE_STRING.equals(lName)) {
                unicodeString = atts.getValue(i);
                continue;
            }
            if (BIDI_LEVEL.equals(lName) && value.length() > 0) {
                try {
                    bidilevel = Integer.parseInt(atts.getValue(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
            }
            if (INDICES.equals(lName)) {
                indicesString = atts.getValue(i);
                continue;
            }
            if (!NAME.equals(lName)) continue;
            name = value;
        }
        if (unicodeString != null) {
            originX = Float.valueOf(originX == null ? -2.1474836E9f : originX.floatValue());
            originY = Float.valueOf(originY == null ? 2.1474836E9f : originY.floatValue());
            String currentCanvasClip = this.canvasStack.size() > 0 ? this.canvasStack.peek() : NULL_CLIP;
            List<GlyphRun> runs = this.canvases.get(currentCanvasClip);
            if (runs == null) {
                runs = new ArrayList<GlyphRun>();
            }
            runs.add(new GlyphRun(name, originY.floatValue(), originX.floatValue(), unicodeString, bidilevel, indicesString));
            this.canvases.put(currentCanvasClip, runs);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (CANVAS.equals(localName)) {
            if (!this.canvasStack.isEmpty()) {
                this.canvasStack.pop();
            }
        } else if (PATH.equals(localName)) {
            if (this.imageSourcePathInZip != null) {
                String val;
                Metadata m4 = this.embeddedInfos.get(this.imageSourcePathInZip);
                if (m4 == null) {
                    m4 = new Metadata();
                }
                if (this.originalLocationOnDrive != null && (val = m4.get(TikaCoreProperties.ORIGINAL_RESOURCE_NAME)) == null) {
                    m4.set(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, this.originalLocationOnDrive);
                }
                m4.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.INLINE.toString());
                this.embeddedInfos.put(this.imageSourcePathInZip, m4);
            }
            this.imageSourcePathInZip = null;
            this.originalLocationOnDrive = null;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.xhml.startElement(DIV, CLASS, PAGE);
    }

    @Override
    public void endDocument() throws SAXException {
        this.writePage();
        this.xhml.endElement(DIV);
    }

    private final void writePage() throws SAXException {
        if (this.canvases.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<GlyphRun>> e : this.canvases.entrySet()) {
            String clip = e.getKey();
            List<GlyphRun> runs = e.getValue();
            if (runs.size() == 0) continue;
            this.xhml.startElement(DIV, CLASS, CANVAS_SAX);
            List<List<GlyphRun>> rows = this.buildRows(runs);
            for (List<GlyphRun> row : rows) {
                this.writeRow(row);
            }
            this.xhml.endElement(DIV);
        }
        if (this.urls.size() > 0) {
            this.xhml.startElement(DIV, CLASS, URL_DIV);
            for (String u : this.urls) {
                this.xhml.startElement(A, HREF, u);
                this.xhml.characters(u);
                this.xhml.endElement(A);
            }
            this.xhml.endElement(DIV);
        }
        this.canvases.clear();
    }

    private void writeRow(List<GlyphRun> row) throws SAXException {
        this.xhml.startElement(P);
        for (GlyphRun run : row) {
            this.xhml.characters(run.unicodeString);
        }
        this.xhml.endElement(P);
    }

    private List<List<GlyphRun>> buildRows(List<GlyphRun> glyphRuns) {
        ArrayList<List<GlyphRun>> rows = new ArrayList<List<GlyphRun>>();
        float maxY = -1.0f;
        for (GlyphRun glyphRun : glyphRuns) {
            if (rows.size() == 0) {
                ArrayList<GlyphRun> row = new ArrayList<GlyphRun>();
                row.add(glyphRun);
                rows.add(row);
                continue;
            }
            boolean addedNewRow = false;
            ArrayList<GlyphRun> row = (ArrayList<GlyphRun>)rows.get(rows.size() - 1);
            if ((double)Math.abs(glyphRun.originY - ((GlyphRun)row.get(0)).originY) < 0.5) {
                row.add(glyphRun);
            } else {
                row = new ArrayList<GlyphRun>();
                row.add(glyphRun);
                rows.add(row);
                addedNewRow = true;
            }
            if (maxY > -1.0f && addedNewRow && glyphRun.originY < maxY) {
                rows.sort(ROW_SORTER);
            }
            if (!(glyphRun.originY > maxY)) continue;
            maxY = glyphRun.originY;
        }
        return rows;
    }

    static final class GlyphRun {
        private final String name;
        private final float originY;
        private final float originX;
        private final String unicodeString;
        private final String indicesString;
        private final DIRECTION direction;

        private GlyphRun(String name, float originY, float originX, String unicodeString, Integer bidiLevel, String indicesString) {
            this.name = name;
            this.unicodeString = unicodeString;
            this.originY = originY;
            this.originX = originX;
            this.direction = bidiLevel == null ? DIRECTION.LTR : (bidiLevel % 2 == 0 ? DIRECTION.LTR : DIRECTION.RTL);
            this.indicesString = indicesString;
        }

        private static enum DIRECTION {
            LTR,
            RTL;

        }
    }
}

