/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import com.microsoft.schemas.vml.impl.CTShapeImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.model.XWPFCommentsDecorator;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ICell;
import org.apache.poi.xwpf.usermodel.IRunElement;
import org.apache.poi.xwpf.usermodel.ISDTContent;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFHyperlink;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFSDTCell;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.EMFParser;
import org.apache.tika.parser.microsoft.FormattingUtils;
import org.apache.tika.parser.microsoft.WordExtractor;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.EmbeddedPartMetadata;
import org.apache.tika.parser.microsoft.ooxml.OOXMLTikaBodyPartHandler;
import org.apache.tika.parser.microsoft.ooxml.OOXMLWordAndPowerPointTextHandler;
import org.apache.tika.parser.microsoft.ooxml.XWPFListManager;
import org.apache.tika.sax.ToTextContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.StringUtils;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XWPFWordExtractorDecorator
extends AbstractOOXMLExtractor {
    private static final String LIST_DELIMITER = " ";
    private static final String[] MAIN_PART_RELATIONS = new String[]{XWPFRelation.HEADER.getRelation(), XWPFRelation.FOOTER.getRelation(), XWPFRelation.FOOTNOTE.getRelation(), "http://schemas.openxmlformats.org/officeDocument/2006/relationships/endnotes", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData"};
    private XWPFDocument document;
    private XWPFStyles styles;
    private Metadata metadata;
    private Map<String, EmbeddedPartMetadata> embeddedPartMetadataMap = new HashMap<String, EmbeddedPartMetadata>();

    public XWPFWordExtractorDecorator(Metadata metadata, ParseContext context, XWPFWordExtractor extractor) {
        super(context, extractor);
        this.metadata = metadata;
        this.document = extractor.getDocument();
        this.styles = this.document.getStyles();
    }

    @Deprecated
    public XWPFWordExtractorDecorator(ParseContext context, XWPFWordExtractor extractor) {
        this(new Metadata(), context, extractor);
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        XWPFHeaderFooterPolicy hfPolicy = this.document.getHeaderFooterPolicy();
        XWPFListManager listManager = new XWPFListManager(this.document.getNumbering());
        if (hfPolicy != null && this.config.isIncludeHeadersAndFooters()) {
            this.extractHeaders(xhtml, hfPolicy, listManager);
        }
        this.extractIBodyText(this.document, listManager, xhtml);
        this.handleGeneralTextContainingPart("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData", "diagram-data", this.document.getPackagePart(), this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), new HashMap<String, String>()));
        this.handleGeneralTextContainingPart(XSSFRelation.CHART.getRelation(), "chart", this.document.getPackagePart(), this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), new HashMap<String, String>()));
        if (hfPolicy != null && this.config.isIncludeHeadersAndFooters()) {
            this.extractFooters(xhtml, hfPolicy, listManager);
        }
    }

    @Override
    protected Map<String, EmbeddedPartMetadata> getEmbeddedPartMetadataMap() {
        return this.embeddedPartMetadataMap;
    }

    private void extractIBodyText(IBody bodyElement, XWPFListManager listManager, XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        for (IBodyElement element : bodyElement.getBodyElements()) {
            if (element instanceof XWPFParagraph) {
                XWPFParagraph paragraph = (XWPFParagraph)element;
                this.extractParagraph(paragraph, listManager, xhtml);
            }
            if (element instanceof XWPFTable) {
                XWPFTable table = (XWPFTable)element;
                this.extractTable(table, listManager, xhtml);
            }
            if (!(element instanceof XWPFSDT)) continue;
            this.extractSDT((XWPFSDT)element, xhtml);
        }
    }

    private void extractSDT(XWPFSDT element, XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        ISDTContent content = element.getContent();
        String tag = "p";
        xhtml.startElement(tag);
        xhtml.characters(content.getText());
        xhtml.endElement(tag);
    }

    private void extractParagraph(XWPFParagraph paragraph, XWPFListManager listManager, XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        String footnameText;
        XWPFCommentsDecorator comments;
        String commentText;
        XWPFStyle style;
        CTSectPr ctSectPr;
        XWPFHeaderFooterPolicy headerFooterPolicy = null;
        if (paragraph.getCTP().getPPr() != null && (ctSectPr = paragraph.getCTP().getPPr().getSectPr()) != null && this.config.isIncludeHeadersAndFooters()) {
            headerFooterPolicy = new XWPFHeaderFooterPolicy(this.document, ctSectPr);
            this.extractHeaders(xhtml, headerFooterPolicy, listManager);
        }
        String tag = "p";
        String styleClass = null;
        if (paragraph.getStyleID() != null && this.styles != null && (style = this.styles.getStyle(paragraph.getStyleID())) != null && style.getName() != null) {
            WordExtractor.TagAndStyle tas = WordExtractor.buildParagraphTagAndStyle(style.getName(), paragraph.getPartType() == BodyType.TABLECELL);
            tag = tas.getTag();
            styleClass = tas.getStyleClass();
        }
        if (styleClass == null) {
            xhtml.startElement(tag);
        } else {
            xhtml.startElement(tag, "class", styleClass);
        }
        this.writeParagraphNumber(paragraph, listManager, xhtml);
        this.processEmbeddedObjects(paragraph.getRuns(), xhtml);
        for (int i = 0; i < paragraph.getCTP().sizeOfBookmarkStartArray(); ++i) {
            CTBookmark bookmark = paragraph.getCTP().getBookmarkStartArray(i);
            xhtml.startElement("a", "name", bookmark.getName());
            xhtml.endElement("a");
        }
        ArrayDeque<FormattingUtils.Tag> formattingState = new ArrayDeque<FormattingUtils.Tag>();
        String lastHyperlinkId = null;
        boolean inHyperlink = false;
        for (IRunElement run : paragraph.getIRuns()) {
            if (run instanceof XWPFHyperlinkRun) {
                XWPFHyperlinkRun hyperlinkRun = (XWPFHyperlinkRun)run;
                if (hyperlinkRun.getHyperlinkId() == null || !hyperlinkRun.getHyperlinkId().equals(lastHyperlinkId)) {
                    if (inHyperlink) {
                        FormattingUtils.closeStyleTags(xhtml, formattingState);
                        xhtml.endElement("a");
                        inHyperlink = false;
                    }
                    lastHyperlinkId = hyperlinkRun.getHyperlinkId();
                    FormattingUtils.closeStyleTags(xhtml, formattingState);
                    XWPFHyperlink link = hyperlinkRun.getHyperlink(this.document);
                    if (link != null && link.getURL() != null) {
                        xhtml.startElement("a", "href", link.getURL());
                        inHyperlink = true;
                    } else if (hyperlinkRun.getAnchor() != null && hyperlinkRun.getAnchor().length() > 0) {
                        xhtml.startElement("a", "href", "#" + hyperlinkRun.getAnchor());
                        inHyperlink = true;
                    }
                }
            } else if (inHyperlink) {
                FormattingUtils.closeStyleTags(xhtml, formattingState);
                xhtml.endElement("a");
                lastHyperlinkId = null;
                inHyperlink = false;
            }
            if (run instanceof XWPFSDT) {
                FormattingUtils.closeStyleTags(xhtml, formattingState);
                this.processSDTRun((XWPFSDT)run, xhtml);
                continue;
            }
            this.processRun((XWPFRun)run, paragraph, xhtml, formattingState);
        }
        FormattingUtils.closeStyleTags(xhtml, formattingState);
        if (inHyperlink) {
            xhtml.endElement("a");
        }
        if ((commentText = (comments = new XWPFCommentsDecorator(paragraph, null)).getCommentText()) != null && commentText.length() > 0) {
            xhtml.characters(commentText);
        }
        if ((footnameText = paragraph.getFootnoteText()) != null && footnameText.length() > 0) {
            xhtml.characters(footnameText + "\n");
        }
        if (this.config.isIncludeShapeBasedContent()) {
            for (XmlObject embeddedParagraph : paragraph.getCTP().selectPath("declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' declare namespace wps='http://schemas.microsoft.com/office/word/2010/wordprocessingShape' .//*/wps:txbx/w:txbxContent//w:p")) {
                this.extractParagraph(new XWPFParagraph((CTP)CTP.Factory.parse(embeddedParagraph.xmlText()), paragraph.getBody()), listManager, xhtml);
            }
        }
        xhtml.endElement(tag);
        if (headerFooterPolicy != null && this.config.isIncludeHeadersAndFooters()) {
            this.extractFooters(xhtml, headerFooterPolicy, listManager);
        }
    }

    private void processEmbeddedObjects(List<XWPFRun> runs, XHTMLContentHandler xhtml) throws SAXException {
        for (XWPFRun run : runs) {
            XmlCursor c = run.getCTR().newCursor();
            Throwable throwable = null;
            try {
                c.selectPath("./*");
                while (c.toNextSelection()) {
                    XmlObject o = c.getObject();
                    if (!(o instanceof CTObject)) continue;
                    XmlCursor objectCursor = o.newCursor();
                    Throwable throwable2 = null;
                    try {
                        this.processObject(objectCursor, xhtml);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (objectCursor == null) continue;
                        if (throwable2 != null) {
                            try {
                                objectCursor.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        objectCursor.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (c == null) continue;
                if (throwable != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                c.close();
            }
        }
    }

    private void processObject(XmlCursor cursor, XHTMLContentHandler xhtml) throws SAXException {
        cursor.selectPath("./*");
        String objectRelId = null;
        String progId = null;
        EmbeddedPartMetadata embeddedPartMetadata = null;
        while (cursor.toNextSelection()) {
            XmlObject relIDAtt;
            XmlObject[] imagedata;
            XmlObject o2 = cursor.getObject();
            XmlObject embedAtt = o2.selectAttribute(new QName("Type"));
            if (embedAtt != null && embedAtt.getDomNode().getNodeValue().equals("Embed")) {
                XmlObject progIDAtt;
                XmlObject relIDAtt2 = o2.selectAttribute(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id"));
                if (relIDAtt2 != null) {
                    objectRelId = relIDAtt2.getDomNode().getNodeValue();
                }
                if ((progIDAtt = o2.selectAttribute(new QName("ProgID"))) == null) continue;
                progId = progIDAtt.getDomNode().getNodeValue();
                continue;
            }
            if (!(o2 instanceof CTShapeImpl) || (imagedata = o2.selectChildren(new QName("urn:schemas-microsoft-com:vml", "imagedata"))).length <= 0 || (relIDAtt = imagedata[0].selectAttribute(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id"))) == null) continue;
            String rid = relIDAtt.getDomNode().getNodeValue();
            embeddedPartMetadata = new EmbeddedPartMetadata(rid);
            this.tryToParseEmbeddedName(rid, embeddedPartMetadata);
        }
        if (objectRelId == null) {
            return;
        }
        if (embeddedPartMetadata != null) {
            if (!StringUtils.isBlank(progId)) {
                embeddedPartMetadata.setProgId(progId);
            }
            this.embeddedPartMetadataMap.put(objectRelId, embeddedPartMetadata);
        }
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "class", "class", "CDATA", "embedded");
        attributes.addAttribute("", "id", "id", "CDATA", objectRelId);
        if (embeddedPartMetadata != null && !StringUtils.isBlank(embeddedPartMetadata.getFullName())) {
            attributes.addAttribute("", "name", "name", "CDATA", embeddedPartMetadata.getFullName());
        }
        xhtml.startElement("div", attributes);
        xhtml.endElement("div");
    }

    private String tryToParseEmbeddedName(String rid, EmbeddedPartMetadata embeddedPartMetadata) {
        POIXMLDocumentPart part = this.document.getRelationById(rid);
        if (part == null || part.getPackagePart() == null || part.getPackagePart().getContentType() == null) {
            return null;
        }
        PackagePart packagePart = part.getPackagePart();
        if ("image/x-emf".equals(packagePart.getContentType())) {
            try (InputStream is = packagePart.getInputStream();){
                EMFParser p = new EMFParser();
                Metadata m4 = new Metadata();
                ParseContext pc = new ParseContext();
                ToTextContentHandler toTextContentHandler = new ToTextContentHandler();
                p.parse(is, toTextContentHandler, m4, pc);
                embeddedPartMetadata.setRenderedName(toTextContentHandler.toString().trim());
                embeddedPartMetadata.setFullName(m4.get(EMFParser.EMF_ICON_STRING));
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void writeParagraphNumber(XWPFParagraph paragraph, XWPFListManager listManager, XHTMLContentHandler xhtml) throws SAXException {
        if (paragraph.getNumIlvl() == null) {
            return;
        }
        String number = listManager.getFormattedNumber(paragraph);
        if (number != null) {
            xhtml.characters(number);
        }
    }

    private void processRun(XWPFRun run, XWPFParagraph paragraph, XHTMLContentHandler xhtml, Deque<FormattingUtils.Tag> formattingState) throws SAXException, XmlException, IOException {
        FormattingUtils.ensureFormattingState(xhtml, FormattingUtils.toTags(run), formattingState);
        if (this.config.isConcatenatePhoneticRuns()) {
            xhtml.characters(run.toString());
        } else {
            xhtml.characters(run.text());
        }
        for (XWPFPicture picture : run.getEmbeddedPictures()) {
            XWPFPictureData data;
            if (paragraph.getDocument() == null || (data = picture.getPictureData()) == null) continue;
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("", "src", "src", "CDATA", "embedded:" + data.getFileName());
            attr.addAttribute("", "alt", "alt", "CDATA", picture.getDescription());
            xhtml.startElement("img", attr);
            xhtml.endElement("img");
        }
    }

    private void processSDTRun(XWPFSDT run, XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        xhtml.characters(run.getContent().getText());
    }

    private void extractTable(XWPFTable table, XWPFListManager listManager, XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        xhtml.startElement("table");
        xhtml.startElement("tbody");
        for (XWPFTableRow row : table.getRows()) {
            xhtml.startElement("tr");
            for (ICell cell : row.getTableICells()) {
                xhtml.startElement("td");
                if (cell instanceof XWPFTableCell) {
                    this.extractIBodyText((XWPFTableCell)cell, listManager, xhtml);
                } else if (cell instanceof XWPFSDTCell) {
                    xhtml.characters(((XWPFSDTCell)cell).getContent().getText());
                }
                xhtml.endElement("td");
            }
            xhtml.endElement("tr");
        }
        xhtml.endElement("tbody");
        xhtml.endElement("table");
    }

    private void extractFooters(XHTMLContentHandler xhtml, XWPFHeaderFooterPolicy hfPolicy, XWPFListManager listManager) throws SAXException, XmlException, IOException {
        if (hfPolicy.getFirstPageFooter() != null) {
            this.extractHeaderText(xhtml, hfPolicy.getFirstPageFooter(), listManager);
        }
        if (hfPolicy.getEvenPageFooter() != null) {
            this.extractHeaderText(xhtml, hfPolicy.getEvenPageFooter(), listManager);
        }
        if (hfPolicy.getDefaultFooter() != null) {
            this.extractHeaderText(xhtml, hfPolicy.getDefaultFooter(), listManager);
        }
    }

    private void extractHeaders(XHTMLContentHandler xhtml, XWPFHeaderFooterPolicy hfPolicy, XWPFListManager listManager) throws SAXException, XmlException, IOException {
        if (hfPolicy == null) {
            return;
        }
        if (hfPolicy.getFirstPageHeader() != null) {
            this.extractHeaderText(xhtml, hfPolicy.getFirstPageHeader(), listManager);
        }
        if (hfPolicy.getEvenPageHeader() != null) {
            this.extractHeaderText(xhtml, hfPolicy.getEvenPageHeader(), listManager);
        }
        if (hfPolicy.getDefaultHeader() != null) {
            this.extractHeaderText(xhtml, hfPolicy.getDefaultHeader(), listManager);
        }
    }

    private void extractHeaderText(XHTMLContentHandler xhtml, XWPFHeaderFooter header, XWPFListManager listManager) throws SAXException, XmlException, IOException {
        for (IBodyElement e : header.getBodyElements()) {
            if (e instanceof XWPFParagraph) {
                this.extractParagraph((XWPFParagraph)e, listManager, xhtml);
                continue;
            }
            if (e instanceof XWPFTable) {
                this.extractTable((XWPFTable)e, listManager, xhtml);
                continue;
            }
            if (!(e instanceof XWPFSDT)) continue;
            this.extractSDT((XWPFSDT)e, xhtml);
        }
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        parts.add(this.document.getPackagePart());
        this.addRelatedParts(this.document.getPackagePart(), parts);
        return parts;
    }

    private void addRelatedParts(PackagePart documentPart, List<PackagePart> relatedParts) {
        for (String relation : MAIN_PART_RELATIONS) {
            PackageRelationshipCollection prc = null;
            try {
                prc = documentPart.getRelationshipsByType(relation);
                if (prc == null) continue;
                for (int i = 0; i < prc.size(); ++i) {
                    PackagePart packagePart = documentPart.getRelatedPart(prc.getRelationship(i));
                    relatedParts.add(packagePart);
                }
            }
            catch (InvalidFormatException invalidFormatException) {
                // empty catch block
            }
        }
    }
}

