/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dwg;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DWGReadFormatRemover {
    private static final String underlineStrikeThrough = "((?:\\\\\\\\)+|\\\\[LlOoKk])";
    private static final String endMarks = "((?:\\\\\\\\)+|\\\\(?:A|H|pi|pxt|pxi|pt|X|Q|f|F|W|C|T)[^;]{0,100};)";
    private static final String newLine = "((?:\\\\\\\\)+|\\\\P)";
    private static final String stackFrac = "(\\\\\\\\)+|\\\\S([^/^#]{1,20})[/^#]([^;]{1,20});";
    private static final String curlyBraces = "(\\\\)+[{}]|([{}])";
    private static final String escapeChars = "(?<!\\\\)(\\\\)(?!\\\\)";

    public String cleanupDwgString(String dwgString) {
        String cleanString = dwgString;
        StringBuffer sb = new StringBuffer();
        Matcher m4 = Pattern.compile(underlineStrikeThrough).matcher(cleanString);
        while (m4.find()) {
            if (m4.group(1).endsWith("\\")) continue;
            m4.appendReplacement(sb, "");
        }
        m4.appendTail(sb);
        cleanString = sb.toString();
        m4 = Pattern.compile(endMarks).matcher(cleanString);
        sb.setLength(0);
        while (m4.find()) {
            if (m4.group(1).endsWith("\\")) continue;
            m4.appendReplacement(sb, "");
        }
        m4.appendTail(sb);
        cleanString = sb.toString();
        m4 = Pattern.compile(newLine).matcher(cleanString);
        sb.setLength(0);
        while (m4.find()) {
            if (!m4.group(1).endsWith("P")) continue;
            m4.appendReplacement(sb, "\n");
        }
        m4.appendTail(sb);
        cleanString = sb.toString();
        m4 = Pattern.compile(stackFrac).matcher(cleanString);
        sb.setLength(0);
        while (m4.find()) {
            if (m4.group(1) != null) continue;
            m4.appendReplacement(sb, m4.group(2) + "/" + m4.group(3));
        }
        m4.appendTail(sb);
        cleanString = sb.toString();
        m4 = Pattern.compile(curlyBraces).matcher(cleanString);
        sb.setLength(0);
        while (m4.find()) {
            if (m4.group(1) != null) continue;
            m4.appendReplacement(sb, "");
        }
        m4.appendTail(sb);
        cleanString = sb.toString();
        cleanString = cleanString.replaceAll(escapeChars, "");
        cleanString = cleanString.replaceAll("(\\\\\\\\)", "\\\\");
        return cleanString;
    }
}

