/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FSUtil {
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("\\A(.*?)(?:\\((\\d+)\\))?\\.([^\\.]+)\\Z");

    @Deprecated
    public static boolean checkThisIsAncestorOfThat(File ancestor, File child) {
        int ancLen = ancestor.getAbsolutePath().length();
        int childLen = child.getAbsolutePath().length();
        if (childLen <= ancLen) {
            return false;
        }
        String childBase = child.getAbsolutePath().substring(0, ancLen);
        return childBase.equals(ancestor.getAbsolutePath());
    }

    @Deprecated
    public static boolean checkThisIsAncestorOfOrSameAsThat(File ancestor, File child) {
        if (ancestor.equals(child)) {
            return true;
        }
        return FSUtil.checkThisIsAncestorOfThat(ancestor, child);
    }

    @Deprecated
    public static File getOutputFile(File outputRoot, String initialRelativePath, HANDLE_EXISTING handleExisting, String suffix) throws IOException {
        return FSUtil.getOutputPath(Paths.get(outputRoot.toURI()), initialRelativePath, handleExisting, suffix).toFile();
    }

    public static Path getOutputPath(Path outputRoot, String initialRelativePath, HANDLE_EXISTING handleExisting, String suffix) throws IOException {
        String localSuffix = suffix == null ? "" : suffix;
        Path cand = FSUtil.resolveRelative(outputRoot, initialRelativePath + "." + localSuffix);
        if (Files.exists(cand, new LinkOption[0])) {
            if (handleExisting.equals((Object)HANDLE_EXISTING.OVERWRITE)) {
                return cand;
            }
            if (handleExisting.equals((Object)HANDLE_EXISTING.SKIP)) {
                return null;
            }
        }
        int cnt = 0;
        String fNameBase = null;
        String fNameExt = "";
        Path candOnly = FSUtil.resolveRelative(outputRoot, initialRelativePath);
        Matcher m4 = FILE_NAME_PATTERN.matcher(candOnly.getFileName().toString());
        if (m4.find()) {
            fNameBase = m4.group(1);
            if (m4.group(2) != null) {
                try {
                    cnt = Integer.parseInt(m4.group(2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (m4.group(3) != null) {
                fNameExt = m4.group(3);
            }
        }
        Path outputParent = cand.getParent();
        while (fNameBase != null && Files.exists(cand, new LinkOption[0]) && ++cnt < 10000) {
            String candFileName = fNameBase + "(" + cnt + ")." + fNameExt + "" + localSuffix;
            cand = FSUtil.resolveRelative(outputParent, candFileName);
        }
        cnt = 0;
        while (Files.exists(cand, new LinkOption[0]) && cnt++ < 20000) {
            UUID uid = UUID.randomUUID();
            cand = FSUtil.resolveRelative(outputParent, uid.toString() + fNameExt + "" + localSuffix);
        }
        if (Files.exists(cand, new LinkOption[0])) {
            throw new IOException("Couldn't find candidate output file after trying very, very hard");
        }
        return cand;
    }

    public static Path resolveRelative(Path p, String other) {
        Path op = Paths.get(other, new String[0]);
        if (op.isAbsolute()) {
            throw new IllegalArgumentException(other + " cannot be an absolute path!");
        }
        return p.resolve(op);
    }

    public static enum HANDLE_EXISTING {
        OVERWRITE,
        RENAME,
        SKIP;

    }
}

