/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.FileResourceCrawlerFutureResult;
import org.apache.tika.batch.IFileProcessorFutureResult;
import org.apache.tika.batch.PoisonFileResource;
import org.apache.tika.extractor.DocumentSelector;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileResourceCrawler
implements Callable<IFileProcessorFutureResult> {
    protected static final Logger LOG = LoggerFactory.getLogger(FileResourceCrawler.class.toString());
    protected static final int SKIPPED = 0;
    protected static final int ADDED = 1;
    protected static final int STOP_NOW = 2;
    private static final long PAUSE_INCREMENT_MILLIS = 1000L;
    private final ArrayBlockingQueue<FileResource> queue;
    private final int numConsumers;
    private volatile boolean hasCompletedCrawling = false;
    private volatile boolean shutDownNoPoison = false;
    private volatile boolean isActive = true;
    private volatile boolean timedOut = false;
    private int maxFilesToAdd = -1;
    private int maxFilesToConsider = -1;
    private long maxConsecWaitInMillis = 300000L;
    private DocumentSelector documentSelector = null;
    private int added = 0;
    private int considered = 0;

    public FileResourceCrawler(ArrayBlockingQueue<FileResource> queue, int numConsumers) {
        this.queue = queue;
        this.numConsumers = numConsumers;
    }

    public abstract void start() throws InterruptedException;

    @Override
    public FileResourceCrawlerFutureResult call() {
        try {
            this.start();
        }
        catch (InterruptedException e) {
            LOG.info("InterruptedException in FileCrawler", e);
        }
        catch (Exception e) {
            LOG.error("Exception in FileResourceCrawler: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.isActive = false;
        }
        try {
            this.shutdown();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new FileResourceCrawlerFutureResult(this.considered, this.added);
    }

    protected int tryToAdd(FileResource fileResource) throws InterruptedException {
        if (this.maxFilesToAdd > -1 && this.added >= this.maxFilesToAdd) {
            return 2;
        }
        if (this.maxFilesToConsider > -1 && this.considered > this.maxFilesToConsider) {
            return 2;
        }
        boolean isAdded = false;
        if (this.select(fileResource.getMetadata())) {
            long start = System.currentTimeMillis();
            while (!this.queue.offer(fileResource, 1000L, TimeUnit.MILLISECONDS)) {
                long elapsed = System.currentTimeMillis() - start;
                LOG.info("FileResourceCrawler is pausing. Queue is full: {} after {} ms", (Object)this.queue.size(), (Object)elapsed);
                if (this.maxConsecWaitInMillis > -1L && elapsed > this.maxConsecWaitInMillis) {
                    this.timedOut = true;
                    String msg = "FileResourceCrawler had to wait longer (" + elapsed + " ms) than allowed (" + this.maxConsecWaitInMillis + " ms)";
                    LOG.error(msg);
                    throw new InterruptedException(msg);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                LOG.info("FileResourceCrawler shutting down because of interrupted thread.");
                throw new InterruptedException("FileResourceCrawler interrupted.");
            }
            isAdded = true;
            ++this.added;
        } else {
            LOG.debug("crawler did not select: {}", (Object)fileResource.getResourceId());
        }
        ++this.considered;
        return isAdded ? 1 : 0;
    }

    private void shutdown() throws InterruptedException {
        LOG.debug("FileResourceCrawler entering shutdown");
        if (this.hasCompletedCrawling || this.shutDownNoPoison) {
            return;
        }
        int i = 0;
        long start = System.currentTimeMillis();
        while (this.queue.offer(new PoisonFileResource(), 1L, TimeUnit.SECONDS)) {
            if (this.shutDownNoPoison) {
                LOG.debug("quitting the poison loop because shutDownNoPoison is now true");
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                LOG.debug("thread interrupted while trying to add poison");
                return;
            }
            long elapsed = System.currentTimeMillis() - start;
            if (this.maxConsecWaitInMillis > -1L && elapsed > this.maxConsecWaitInMillis) {
                LOG.error("Crawler timed out while trying to add poison");
                return;
            }
            LOG.debug("added {} number of PoisonFileResource(s)", (Object)i);
            if (i++ < this.numConsumers) continue;
            break;
        }
        this.hasCompletedCrawling = true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setMaxConsecWaitInMillis(long maxConsecWaitInMillis) {
        this.maxConsecWaitInMillis = maxConsecWaitInMillis;
    }

    public void setDocumentSelector(DocumentSelector documentSelector) {
        this.documentSelector = documentSelector;
    }

    public int getConsidered() {
        return this.considered;
    }

    protected boolean select(Metadata m4) {
        return this.documentSelector.select(m4);
    }

    public void setMaxFilesToAdd(int maxFilesToAdd) {
        this.maxFilesToAdd = maxFilesToAdd;
    }

    public void setMaxFilesToConsider(int maxFilesToConsider) {
        this.maxFilesToConsider = maxFilesToConsider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueueEmpty() {
        int size = 0;
        ArrayBlockingQueue<FileResource> arrayBlockingQueue = this.queue;
        synchronized (arrayBlockingQueue) {
            for (FileResource aQueue : this.queue) {
                if (aQueue instanceof PoisonFileResource) continue;
                ++size;
            }
        }
        return size == 0;
    }

    public boolean wasTimedOut() {
        return this.timedOut;
    }

    public int getAdded() {
        return this.added;
    }

    public void shutDownNoPoison() {
        this.shutDownNoPoison = true;
    }
}

