/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.util.Vector;
import org.apache.commons.exec.ProcessDestroyer;

public class ShutdownHookProcessDestroyer
implements ProcessDestroyer,
Runnable {
    private final Vector<Process> processes = new Vector();
    private ProcessDestroyerThread destroyProcessThread;
    private boolean added;
    private volatile boolean running;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Process process) {
        Vector<Process> vector = this.processes;
        synchronized (vector) {
            if (this.processes.isEmpty()) {
                this.addShutdownHook();
            }
            this.processes.addElement(process);
            return this.processes.contains(process);
        }
    }

    private void addShutdownHook() {
        if (!this.running) {
            this.destroyProcessThread = new ProcessDestroyerThread();
            Runtime.getRuntime().addShutdownHook(this.destroyProcessThread);
            this.added = true;
        }
    }

    public boolean isAddedAsShutdownHook() {
        return this.added;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Process process) {
        Vector<Process> vector = this.processes;
        synchronized (vector) {
            boolean processRemoved = this.processes.removeElement(process);
            if (processRemoved && this.processes.isEmpty()) {
                this.removeShutdownHook();
            }
            return processRemoved;
        }
    }

    private void removeShutdownHook() {
        if (this.added && !this.running) {
            boolean removed = Runtime.getRuntime().removeShutdownHook(this.destroyProcessThread);
            if (!removed) {
                System.err.println("Could not remove shutdown hook");
            }
            this.destroyProcessThread.setShouldDestroy(false);
            this.destroyProcessThread.start();
            try {
                this.destroyProcessThread.join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.destroyProcessThread = null;
            this.added = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Vector<Process> vector = this.processes;
        synchronized (vector) {
            this.running = true;
            this.processes.forEach(process -> {
                try {
                    process.destroy();
                }
                catch (Throwable t2) {
                    System.err.println("Unable to terminate process during process shutdown");
                }
            });
        }
    }

    @Override
    public int size() {
        return this.processes.size();
    }

    private final class ProcessDestroyerThread
    extends Thread {
        private boolean shouldDestroy;

        public ProcessDestroyerThread() {
            super("ProcessDestroyer Shutdown Hook");
            this.shouldDestroy = true;
        }

        @Override
        public void run() {
            if (this.shouldDestroy) {
                ShutdownHookProcessDestroyer.this.run();
            }
        }

        public void setShouldDestroy(boolean shouldDestroy) {
            this.shouldDestroy = shouldDestroy;
        }
    }
}

