/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.RandomAccess;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import net.arnx.jsonic.AppendableConverter;
import net.arnx.jsonic.ArrayConverter;
import net.arnx.jsonic.BigDecimalConverter;
import net.arnx.jsonic.BigIntegerConverter;
import net.arnx.jsonic.BooleanArrayFormatter;
import net.arnx.jsonic.BooleanConverter;
import net.arnx.jsonic.ByteArrayFormatter;
import net.arnx.jsonic.ByteConverter;
import net.arnx.jsonic.ByteFormatter;
import net.arnx.jsonic.CalendarConverter;
import net.arnx.jsonic.CalendarFormatter;
import net.arnx.jsonic.CharArrayFormatter;
import net.arnx.jsonic.CharSequenceConverter;
import net.arnx.jsonic.CharacterConverter;
import net.arnx.jsonic.CharacterDataFormatter;
import net.arnx.jsonic.CharsetConverter;
import net.arnx.jsonic.CharsetFormatter;
import net.arnx.jsonic.ClassConverter;
import net.arnx.jsonic.ClassFormatter;
import net.arnx.jsonic.CollectionConverter;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.DOMDocumentFormatter;
import net.arnx.jsonic.DOMElementFormatter;
import net.arnx.jsonic.DateConverter;
import net.arnx.jsonic.DateFormatter;
import net.arnx.jsonic.DoubleArrayFormatter;
import net.arnx.jsonic.DoubleConverter;
import net.arnx.jsonic.DynaBeanFormatter;
import net.arnx.jsonic.EnumConverter;
import net.arnx.jsonic.EnumFormatter;
import net.arnx.jsonic.EnumerationFormatter;
import net.arnx.jsonic.FileConverter;
import net.arnx.jsonic.FloatArrayFormatter;
import net.arnx.jsonic.FloatConverter;
import net.arnx.jsonic.FloatFormatter;
import net.arnx.jsonic.FormatConverter;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.InetAddressConverter;
import net.arnx.jsonic.InetAddressFormatter;
import net.arnx.jsonic.IntArrayFormatter;
import net.arnx.jsonic.IntegerConverter;
import net.arnx.jsonic.IterableFormatter;
import net.arnx.jsonic.IteratorFormatter;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.ListFormatter;
import net.arnx.jsonic.LocaleConverter;
import net.arnx.jsonic.LocaleFormatter;
import net.arnx.jsonic.LongArrayFormatter;
import net.arnx.jsonic.LongConverter;
import net.arnx.jsonic.MapConverter;
import net.arnx.jsonic.MapFormatter;
import net.arnx.jsonic.NamingStyle;
import net.arnx.jsonic.NullConverter;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.NumberFormatter;
import net.arnx.jsonic.ObjectArrayFormatter;
import net.arnx.jsonic.ObjectConverter;
import net.arnx.jsonic.ObjectFormatter;
import net.arnx.jsonic.PatternConverter;
import net.arnx.jsonic.PlainConverter;
import net.arnx.jsonic.PlainFormatter;
import net.arnx.jsonic.PropertiesConverter;
import net.arnx.jsonic.SQLArrayFormatter;
import net.arnx.jsonic.SerializableConverter;
import net.arnx.jsonic.SerializableFormatter;
import net.arnx.jsonic.ShortArrayFormatter;
import net.arnx.jsonic.ShortConverter;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.StringSerializableConverter;
import net.arnx.jsonic.StructFormmatter;
import net.arnx.jsonic.TimeZoneConverter;
import net.arnx.jsonic.TimeZoneFormatter;
import net.arnx.jsonic.URIConverter;
import net.arnx.jsonic.URLConverter;
import net.arnx.jsonic.UUIDConverter;
import net.arnx.jsonic.io.AppendableOutputSource;
import net.arnx.jsonic.io.CharSequenceInputSource;
import net.arnx.jsonic.io.InputSource;
import net.arnx.jsonic.io.OutputSource;
import net.arnx.jsonic.io.ReaderInputSource;
import net.arnx.jsonic.io.StringBuilderOutputSource;
import net.arnx.jsonic.io.WriterOutputSource;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.ExtendedDateFormat;
import net.arnx.jsonic.util.PropertyInfo;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSON {
    public static volatile Class<? extends JSON> prototype = JSON.class;
    private static final Map<Class<?>, Formatter> FORMAT_MAP = new HashMap(50);
    private static final Map<Class<?>, Converter> CONVERT_MAP = new HashMap(50);
    private static final int[] ESCAPE_CHARS = new int[128];
    private Object contextObject;
    private Locale locale = Locale.getDefault();
    private TimeZone timeZone = TimeZone.getDefault();
    private boolean prettyPrint = false;
    private int maxDepth = 32;
    private boolean suppressNull = false;
    private Mode mode = Mode.TRADITIONAL;
    private String dateFormat;
    private String numberFormat;
    private NamingStyle propertyStyle;
    private NamingStyle enumStyle;

    static JSON newInstance() {
        JSON jSON = null;
        try {
            jSON = prototype.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        return jSON;
    }

    public static String encode(Object object) throws JSONException {
        return JSON.encode(object, false);
    }

    public static String encode(Object object, boolean bl) throws JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setPrettyPrint(bl);
        return jSON.format(object);
    }

    public static void encode(Object object, OutputStream outputStream) throws IOException, JSONException {
        JSON.newInstance().format(object, new OutputStreamWriter(outputStream, "UTF-8"));
    }

    public static void encode(Object object, OutputStream outputStream, boolean bl) throws IOException, JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setPrettyPrint(bl);
        jSON.format(object, new OutputStreamWriter(outputStream, "UTF-8"));
    }

    public static void encode(Object object, Appendable appendable) throws IOException, JSONException {
        JSON.newInstance().format(object, appendable);
    }

    public static void encode(Object object, Appendable appendable, boolean bl) throws IOException, JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setPrettyPrint(bl);
        jSON.format(object, appendable);
    }

    public static String escapeScript(Object object) throws JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setMode(Mode.SCRIPT);
        return jSON.format(object);
    }

    public static void escapeScript(Object object, OutputStream outputStream) throws IOException, JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setMode(Mode.SCRIPT);
        jSON.format(object, outputStream);
    }

    public static void escapeScript(Object object, Appendable appendable) throws IOException, JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setMode(Mode.SCRIPT);
        jSON.format(object, appendable);
    }

    public static <T> T decode(String string) throws JSONException {
        return JSON.newInstance().parse(string);
    }

    public static <T> T decode(String string, Class<? extends T> clazz) throws JSONException {
        return JSON.newInstance().parse((CharSequence)string, clazz);
    }

    public static <T> T decode(String string, Type type) throws JSONException {
        return JSON.newInstance().parse((CharSequence)string, type);
    }

    public static <T> T decode(InputStream inputStream) throws IOException, JSONException {
        return JSON.newInstance().parse(inputStream);
    }

    public static <T> T decode(InputStream inputStream, Class<? extends T> clazz) throws IOException, JSONException {
        return JSON.newInstance().parse(inputStream, clazz);
    }

    public static <T> T decode(InputStream inputStream, Type type) throws IOException, JSONException {
        return JSON.newInstance().parse(inputStream, type);
    }

    public static <T> T decode(Reader reader) throws IOException, JSONException {
        return JSON.newInstance().parse(reader);
    }

    public static <T> T decode(Reader reader, Class<? extends T> clazz) throws IOException, JSONException {
        return JSON.newInstance().parse(reader, clazz);
    }

    public static <T> T decode(Reader reader, Type type) throws IOException, JSONException {
        return JSON.newInstance().parse(reader, type);
    }

    public static void validate(CharSequence charSequence) throws JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setMode(Mode.STRICT);
        jSON.setMaxDepth(0);
        jSON.parse(charSequence);
    }

    public static void validate(InputStream inputStream) throws IOException, JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setMode(Mode.STRICT);
        jSON.setMaxDepth(0);
        jSON.parse(inputStream);
    }

    public static void validate(Reader reader) throws IOException, JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setMode(Mode.STRICT);
        jSON.setMaxDepth(0);
        jSON.parse(reader);
    }

    public JSON() {
    }

    public JSON(int n) {
        this.setMaxDepth(n);
    }

    public JSON(Mode mode) {
        this.setMode(mode);
    }

    public void setContext(Object object) {
        this.contextObject = object;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.locale = locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException();
        }
        this.timeZone = timeZone;
    }

    public void setPrettyPrint(boolean bl) {
        this.prettyPrint = bl;
    }

    public void setMaxDepth(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(this.getMessage("json.TooSmallArgumentError", "maxDepth", 0));
        }
        this.maxDepth = n;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setSuppressNull(boolean bl) {
        this.suppressNull = bl;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException();
        }
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string;
    }

    public void setNumberFormat(String string) {
        this.numberFormat = string;
    }

    public void setPropertyStyle(NamingStyle namingStyle) {
        this.propertyStyle = namingStyle;
    }

    public void setEnumStyle(NamingStyle namingStyle) {
        this.enumStyle = namingStyle;
    }

    public String format(Object object) {
        String string = null;
        try {
            string = this.format(object, new StringBuilder(1000)).toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public OutputStream format(Object object, OutputStream outputStream) throws IOException {
        this.format(object, new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8")));
        return outputStream;
    }

    public Appendable format(Object object, Appendable appendable) throws IOException {
        Context context = new Context();
        OutputSource outputSource = appendable instanceof Writer ? new WriterOutputSource((Writer)appendable) : (appendable instanceof StringBuilder ? new StringBuilderOutputSource((StringBuilder)appendable) : new AppendableOutputSource(appendable));
        context.enter(Character.valueOf('$'));
        object = this.preformatInternal(context, object);
        this.formatInternal(context, object, outputSource);
        context.exit();
        outputSource.flush();
        return appendable;
    }

    protected Object preformat(Context context, Object object) throws Exception {
        return object;
    }

    final Object preformatInternal(Context context, Object object) {
        if (object == null) {
            return null;
        }
        if (context.getDepth() > context.getMaxDepth()) {
            return null;
        }
        if (this.getClass() != JSON.class) {
            try {
                return this.preformat(context, object);
            }
            catch (Exception exception) {
                throw new JSONException(this.getMessage("json.format.ConversionError", object, context), 150, exception);
            }
        }
        return object;
    }

    final Formatter formatInternal(Context context, Object object, OutputSource outputSource) throws IOException {
        boolean bl;
        Object object2 = object;
        Formatter formatter = null;
        if (object2 == null) {
            formatter = NullFormatter.INSTANCE;
        } else {
            JSONHint jSONHint = context.getHint();
            if (jSONHint != null) {
                if (jSONHint.serialized() && jSONHint != context.skipHint) {
                    formatter = PlainFormatter.INSTANCE;
                } else if (String.class.equals(jSONHint.type())) {
                    formatter = StringFormatter.INSTANCE;
                } else if (Serializable.class.equals(jSONHint.type())) {
                    formatter = SerializableFormatter.INSTANCE;
                }
            }
        }
        if (formatter == null) {
            formatter = FORMAT_MAP.get(object2.getClass());
        }
        if (formatter == null) {
            if (context.hasMemberCache(object2.getClass())) {
                formatter = ObjectFormatter.INSTANCE;
            } else if (object2 instanceof Map) {
                formatter = MapFormatter.INSTANCE;
            } else if (object2 instanceof Iterable) {
                formatter = object2 instanceof RandomAccess && object2 instanceof List ? ListFormatter.INSTANCE : IterableFormatter.INSTANCE;
            } else if (object2 instanceof Object[]) {
                formatter = ObjectArrayFormatter.INSTANCE;
            } else if (object2 instanceof Enum) {
                formatter = EnumFormatter.INSTANCE;
            } else if (object2 instanceof CharSequence) {
                formatter = StringFormatter.INSTANCE;
            } else if (object2 instanceof Date) {
                formatter = DateFormatter.INSTANCE;
            } else if (object2 instanceof Calendar) {
                formatter = CalendarFormatter.INSTANCE;
            } else if (object2 instanceof Number) {
                formatter = NumberFormatter.INSTANCE;
            } else if (object2 instanceof Iterator) {
                formatter = IteratorFormatter.INSTANCE;
            } else if (object2 instanceof Enumeration) {
                formatter = EnumerationFormatter.INSTANCE;
            } else if (object2 instanceof Type || object2 instanceof Member || object2 instanceof File) {
                formatter = StringFormatter.INSTANCE;
            } else if (object2 instanceof TimeZone) {
                formatter = TimeZoneFormatter.INSTANCE;
            } else if (object2 instanceof Charset) {
                formatter = CharsetFormatter.INSTANCE;
            } else if (object2 instanceof Array) {
                formatter = SQLArrayFormatter.INSTANCE;
            } else if (object2 instanceof Struct) {
                formatter = StructFormmatter.INSTANCE;
            } else if (object2 instanceof Node) {
                if (object2 instanceof CharacterData && !(object2 instanceof Comment)) {
                    formatter = CharacterDataFormatter.INSTANCE;
                } else if (object2 instanceof Document) {
                    formatter = DOMDocumentFormatter.INSTANCE;
                } else if (object2 instanceof Element) {
                    formatter = DOMElementFormatter.INSTANCE;
                }
            } else {
                formatter = JSON.isAssignableFrom(ClassUtil.findClass("java.sql.RowId"), object2.getClass()) ? SerializableFormatter.INSTANCE : (JSON.isAssignableFrom(ClassUtil.findClass("java.net.InetAddress"), object2.getClass()) ? InetAddressFormatter.INSTANCE : (JSON.isAssignableFrom(ClassUtil.findClass("org.apache.commons.beanutils.DynaBean"), object2.getClass()) ? DynaBeanFormatter.INSTANCE : ObjectFormatter.INSTANCE));
            }
        }
        try {
            bl = formatter.format(this, context, object, object2, outputSource);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new JSONException(this.getMessage("json.format.ConversionError", object instanceof CharSequence ? "\"" + object + "\"" : object, context), 100, exception);
        }
        if (!bl && context.getDepth() == 0 && context.getMode() != Mode.SCRIPT) {
            throw new JSONException(this.getMessage("json.format.IllegalRootTypeError", new Object[0]), 100);
        }
        return formatter;
    }

    public <T> T parse(CharSequence charSequence) throws JSONException {
        Object object = null;
        try {
            object = this.parseInternal(new Context(), new CharSequenceInputSource(charSequence));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (T)object;
    }

    public <T> T parse(CharSequence charSequence, Class<? extends T> clazz) throws JSONException {
        return this.parse(charSequence, (Type)clazz);
    }

    public <T> T parse(CharSequence charSequence, Type type) throws JSONException {
        T t2 = null;
        try {
            Context context = new Context();
            t2 = this.convert(context, this.parseInternal(context, new CharSequenceInputSource(charSequence)), type);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return t2;
    }

    public <T> T parse(InputStream inputStream) throws IOException, JSONException {
        return (T)this.parseInternal(new Context(), new ReaderInputSource(inputStream));
    }

    public <T> T parse(InputStream inputStream, Class<? extends T> clazz) throws IOException, JSONException {
        return this.parse(inputStream, (Type)clazz);
    }

    public <T> T parse(InputStream inputStream, Type type) throws IOException, JSONException {
        Context context = new Context();
        return this.convert(context, this.parseInternal(context, new ReaderInputSource(inputStream)), type);
    }

    public <T> T parse(Reader reader) throws IOException, JSONException {
        return (T)this.parseInternal(new Context(), new ReaderInputSource(reader));
    }

    public <T> T parse(Reader reader, Class<? extends T> clazz) throws IOException, JSONException {
        return this.parse(reader, (Type)clazz);
    }

    public <T> T parse(Reader reader, Type type) throws IOException, JSONException {
        Context context = new Context();
        return this.convert(context, this.parseInternal(context, new ReaderInputSource(reader)), type);
    }

    private Object parseInternal(Context context, InputSource inputSource) throws IOException, JSONException {
        boolean bl = true;
        Map<Object, Object> map = null;
        int n = -1;
        block7: while ((n = inputSource.next()) != -1) {
            char c = (char)n;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\ufeff': {
                    continue block7;
                }
                case '{': {
                    if (bl) {
                        inputSource.back();
                        map = this.parseObject(context, inputSource, 1);
                        bl = false;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
                case '[': {
                    if (bl) {
                        inputSource.back();
                        map = this.parseArray(context, inputSource, 1);
                        bl = false;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
                case '#': 
                case '/': {
                    if (context.getMode() == Mode.TRADITIONAL || context.getMode() == Mode.SCRIPT && c == '/') {
                        inputSource.back();
                        this.skipComment(context, inputSource);
                        continue block7;
                    }
                }
                case '\"': 
                case '\'': {
                    if (context.getMode() != Mode.SCRIPT) break;
                    if (bl) {
                        inputSource.back();
                        map = this.parseString(context, inputSource, 1);
                        bl = false;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
            }
            if (context.getMode() == Mode.SCRIPT) {
                if (bl) {
                    inputSource.back();
                    map = c == '-' || c >= '0' && c <= '9' ? this.parseNumber(context, inputSource, 1) : this.parseLiteral(context, inputSource, 1, false);
                    bl = false;
                    continue;
                }
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
            }
            if (context.getMode() == Mode.TRADITIONAL && bl) {
                inputSource.back();
                map = this.parseObject(context, inputSource, 1);
                bl = false;
                continue;
            }
            throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
        }
        if (bl) {
            if (context.getMode() == Mode.TRADITIONAL) {
                map = new LinkedHashMap();
            } else {
                throw this.createParseException(this.getMessage("json.parse.EmptyInputError", new Object[0]), inputSource);
            }
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Map<Object, Object> parseObject(Context context, InputSource inputSource, int n) throws IOException, JSONException {
        int n2 = 0;
        LinkedHashMap<Object, Object> linkedHashMap = n <= context.getMaxDepth() ? new LinkedHashMap<Object, Object>() : null;
        Object object = null;
        int n3 = 0;
        int n4 = -1;
        block12: while ((n4 = inputSource.next()) != -1) {
            Object object2;
            char c = (char)n4;
            switch (c) {
                case '\n': 
                case '\r': {
                    if (context.getMode() != Mode.TRADITIONAL || n2 != 5) continue block12;
                    n2 = 6;
                    continue block12;
                }
                case '\t': 
                case ' ': 
                case '\ufeff': {
                    continue block12;
                }
                case '{': {
                    if (n2 == 0) {
                        n3 = 123;
                        n2 = 1;
                        continue block12;
                    }
                    if (n2 != 2 && n2 != 3) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                    }
                    inputSource.back();
                    object2 = this.parseObject(context, inputSource, n + 1);
                    if (n < context.getMaxDepth()) {
                        linkedHashMap.put(object, object2);
                    }
                    n2 = 5;
                    continue block12;
                }
                case ':': {
                    if (n2 != 2) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                    }
                    n2 = 3;
                    continue block12;
                }
                case ',': {
                    if (n2 == 5 || n2 == 6 || context.getMode() == Mode.TRADITIONAL && n2 == 3) {
                        if (n2 == 3 && n < context.getMaxDepth() && !context.isSuppressNull()) {
                            linkedHashMap.put(object, null);
                        }
                        n2 = 1;
                        continue block12;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
                case '}': {
                    if (n3 == 123 && (n2 == 1 || n2 == 5 || n2 == 6 || context.getMode() == Mode.TRADITIONAL && n2 == 3)) {
                        if (n2 != 3 || n >= context.getMaxDepth() || context.isSuppressNull()) break block12;
                        linkedHashMap.put(object, null);
                        break block12;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
                case '[': {
                    if (n2 != 3) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                    }
                    inputSource.back();
                    object2 = this.parseArray(context, inputSource, n + 1);
                    if (n < context.getMaxDepth()) {
                        linkedHashMap.put(object, object2);
                    }
                    n2 = 5;
                    continue block12;
                }
                case '\'': {
                    if (context.getMode() == Mode.STRICT) break;
                }
                case '\"': {
                    if (n2 == 0) {
                        inputSource.back();
                        n2 = 1;
                        continue block12;
                    }
                    if (n2 == 1 || n2 == 6) {
                        inputSource.back();
                        object = this.parseString(context, inputSource, n + 1);
                        n2 = 2;
                        continue block12;
                    }
                    if (n2 != 3) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                    }
                    inputSource.back();
                    object2 = this.parseString(context, inputSource, n + 1);
                    if (n < context.getMaxDepth()) {
                        linkedHashMap.put(object, object2);
                    }
                    n2 = 5;
                    continue block12;
                }
                case '#': 
                case '/': {
                    if (context.getMode() != Mode.TRADITIONAL && (context.getMode() != Mode.SCRIPT || c != '/')) break;
                    inputSource.back();
                    this.skipComment(context, inputSource);
                    if (n2 != 5) continue block12;
                    n2 = 6;
                    continue block12;
                }
            }
            if (n2 == 0) {
                inputSource.back();
                n2 = 1;
                continue;
            }
            if (n2 == 1 || n2 == 6) {
                inputSource.back();
                object = c == '-' || c >= '0' && c <= '9' ? this.parseNumber(context, inputSource, n + 1) : this.parseLiteral(context, inputSource, n + 1, context.getMode() != Mode.STRICT);
                n2 = 2;
                continue;
            }
            if (n2 != 3) {
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
            }
            inputSource.back();
            Object object3 = c == '-' || c >= '0' && c <= '9' ? this.parseNumber(context, inputSource, n + 1) : (object2 = this.parseLiteral(context, inputSource, n + 1, context.getMode() == Mode.TRADITIONAL));
            if (!(n >= context.getMaxDepth() || object2 == null && context.isSuppressNull())) {
                linkedHashMap.put(object, object2);
            }
            n2 = 5;
        }
        if (n4 == -1) {
            if (n2 == 3 || n2 == 4) {
                if (n < context.getMaxDepth() && !context.isSuppressNull()) {
                    linkedHashMap.put(object, null);
                }
            } else if (n2 == 2) {
                throw this.createParseException(this.getMessage("json.parse.ObjectNotClosedError", new Object[0]), inputSource);
            }
        }
        if (n4 == -1) {
            if (n3 == 0) return linkedHashMap;
            throw this.createParseException(this.getMessage("json.parse.ObjectNotClosedError", new Object[0]), inputSource);
        }
        if (n4 == 125) return linkedHashMap;
        throw this.createParseException(this.getMessage("json.parse.ObjectNotClosedError", new Object[0]), inputSource);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<Object> parseArray(Context context, InputSource inputSource, int n) throws IOException, JSONException {
        int n2 = 0;
        ArrayList<Object> arrayList = n <= context.getMaxDepth() ? new ArrayList<Object>() : null;
        int n3 = -1;
        block11: while ((n3 = inputSource.next()) != -1) {
            Object object;
            char c = (char)n3;
            switch (c) {
                case '\n': 
                case '\r': {
                    if (context.getMode() != Mode.TRADITIONAL || n2 != 2) continue block11;
                    n2 = 3;
                    continue block11;
                }
                case '\t': 
                case ' ': 
                case '\ufeff': {
                    continue block11;
                }
                case '[': {
                    if (n2 == 0) {
                        n2 = 1;
                        continue block11;
                    }
                    if (n2 != 1 && n2 != 3 && n2 != 4) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                    }
                    inputSource.back();
                    object = this.parseArray(context, inputSource, n + 1);
                    if (n < context.getMaxDepth()) {
                        arrayList.add(object);
                    }
                    n2 = 2;
                    continue block11;
                }
                case ',': {
                    if (context.getMode() == Mode.TRADITIONAL && (n2 == 1 || n2 == 4)) {
                        if (n >= context.getMaxDepth()) continue block11;
                        arrayList.add(null);
                        continue block11;
                    }
                    if (n2 != 2 && n2 != 3) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                    }
                    n2 = 4;
                    continue block11;
                }
                case ']': {
                    if (n2 == true || n2 == 2 || n2 == 3) break block11;
                    if (context.getMode() == Mode.TRADITIONAL && n2 == 4) {
                        if (n >= context.getMaxDepth()) break block11;
                        arrayList.add(null);
                        break block11;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
                case '{': {
                    if (n2 != 1 && n2 != 3 && n2 != 4) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                    }
                    inputSource.back();
                    object = this.parseObject(context, inputSource, n + 1);
                    if (n < context.getMaxDepth()) {
                        arrayList.add(object);
                    }
                    n2 = 2;
                    continue block11;
                }
                case '\'': {
                    if (context.getMode() == Mode.STRICT) break;
                }
                case '\"': {
                    if (n2 != 1 && n2 != 3 && n2 != 4) {
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                    }
                    inputSource.back();
                    object = this.parseString(context, inputSource, n + 1);
                    if (n < context.getMaxDepth()) {
                        arrayList.add(object);
                    }
                    n2 = 2;
                    continue block11;
                }
                case '#': 
                case '/': {
                    if (context.getMode() != Mode.TRADITIONAL && (context.getMode() != Mode.SCRIPT || c != '/')) break;
                    inputSource.back();
                    this.skipComment(context, inputSource);
                    if (n2 != 2) continue block11;
                    n2 = 3;
                    continue block11;
                }
            }
            if (n2 != 1 && n2 != 3 && n2 != 4) {
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
            }
            inputSource.back();
            Object object2 = c == '-' || c >= '0' && c <= '9' ? this.parseNumber(context, inputSource, n + 1) : (object = this.parseLiteral(context, inputSource, n + 1, context.getMode() == Mode.TRADITIONAL));
            if (n < context.getMaxDepth()) {
                arrayList.add(object);
            }
            n2 = 2;
        }
        if (n3 != 93) {
            throw this.createParseException(this.getMessage("json.parse.ArrayNotClosedError", new Object[0]), inputSource);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String parseString(Context context, InputSource inputSource, int n) throws IOException, JSONException {
        int n2;
        StringBuilder stringBuilder = n <= context.getMaxDepth() ? context.getCachedBuffer() : null;
        int n3 = 0;
        int n4 = -1;
        block10: while ((n2 = inputSource.next()) != -1) {
            char c = (char)n2;
            if (n3 == 0) {
                switch (c) {
                    case '\'': {
                        if (context.getMode() == Mode.STRICT) {
                            throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                        }
                    }
                    case '\"': {
                        n3 = c;
                        continue block10;
                    }
                }
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
            }
            if (c < ESCAPE_CHARS.length) {
                switch (ESCAPE_CHARS[c]) {
                    case 0: {
                        if (stringBuilder == null) break;
                        stringBuilder.append(c);
                        continue block10;
                    }
                    case 1: {
                        if (context.getMode() == Mode.STRICT) {
                            throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                        }
                        if (stringBuilder == null) break;
                        stringBuilder.append(c);
                        continue block10;
                    }
                    case 2: {
                        if (n3 == c) break block10;
                        if (stringBuilder == null) break;
                        stringBuilder.append(c);
                        continue block10;
                    }
                    case 3: {
                        if (context.getMode() != Mode.TRADITIONAL || n3 == 34) {
                            inputSource.back();
                            c = this.parseEscape(inputSource);
                        }
                        if (stringBuilder == null) break;
                        stringBuilder.append(c);
                    }
                }
                continue;
            }
            if (c == '\ufeff' || stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        if (n2 != n3) {
            throw this.createParseException(this.getMessage("json.parse.StringNotClosedError", new Object[0]), inputSource);
        }
        if (stringBuilder == null) return null;
        String string = stringBuilder.toString();
        return string;
    }

    private Object parseLiteral(Context context, InputSource inputSource, int n, boolean bl) throws IOException, JSONException {
        String string;
        boolean bl2 = false;
        StringBuilder stringBuilder = context.getCachedBuffer();
        int n2 = -1;
        while ((n2 = inputSource.next()) != -1) {
            char c = (char)n2;
            if (c == '\ufeff') continue;
            if (c == '\\') {
                inputSource.back();
                c = this.parseEscape(inputSource);
            }
            if (!bl2 && Character.isJavaIdentifierStart(c)) {
                stringBuilder.append(c);
                bl2 = true;
                continue;
            }
            if (bl2 && (Character.isJavaIdentifierPart(c) || c == '.')) {
                stringBuilder.append(c);
                continue;
            }
            inputSource.back();
            break;
        }
        if ("null".equals(string = stringBuilder.toString())) {
            return null;
        }
        if ("true".equals(string)) {
            return true;
        }
        if ("false".equals(string)) {
            return false;
        }
        if (!bl) {
            throw this.createParseException(this.getMessage("json.parse.UnrecognizedLiteral", string), inputSource);
        }
        return string;
    }

    private Number parseNumber(Context context, InputSource inputSource, int n) throws IOException, JSONException {
        int n2 = 0;
        StringBuilder stringBuilder = n <= context.getMaxDepth() ? context.getCachedBuffer() : null;
        int n3 = -1;
        block7: while ((n3 = inputSource.next()) != -1) {
            char c = (char)n3;
            switch (c) {
                case '\ufeff': {
                    continue block7;
                }
                case '+': {
                    if (n2 == 7) {
                        if (stringBuilder != null) {
                            stringBuilder.append(c);
                        }
                        n2 = 8;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
                case '-': {
                    if (n2 == 0) {
                        if (stringBuilder != null) {
                            stringBuilder.append(c);
                        }
                        n2 = 1;
                        continue block7;
                    }
                    if (n2 == 7) {
                        if (stringBuilder != null) {
                            stringBuilder.append(c);
                        }
                        n2 = 8;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
                case '.': {
                    if (n2 == 2 || n2 == 3) {
                        if (stringBuilder != null) {
                            stringBuilder.append(c);
                        }
                        n2 = 4;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
                case 'E': 
                case 'e': {
                    if (n2 == 2 || n2 == 3 || n2 == 5 || n2 == 6) {
                        if (stringBuilder != null) {
                            stringBuilder.append(c);
                        }
                        n2 = 7;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
            }
            if (c >= '0' && c <= '9') {
                if (n2 == 0 || n2 == 1) {
                    if (stringBuilder != null) {
                        stringBuilder.append(c);
                    }
                    n2 = c == '0' ? 3 : 2;
                    continue;
                }
                if (n2 == 2 || n2 == 5 || n2 == 9) {
                    if (stringBuilder == null) continue;
                    stringBuilder.append(c);
                    continue;
                }
                if (n2 == 4) {
                    if (stringBuilder != null) {
                        stringBuilder.append(c);
                    }
                    n2 = 5;
                    continue;
                }
                if (n2 == 7 || n2 == 8) {
                    if (stringBuilder != null) {
                        stringBuilder.append(c);
                    }
                    n2 = 9;
                    continue;
                }
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
            }
            if (n2 == 2 || n2 == 3 || n2 == 5 || n2 == 6 || n2 == 9) {
                inputSource.back();
                break;
            }
            throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
        }
        return stringBuilder != null ? new BigDecimal(stringBuilder.toString()) : null;
    }

    private char parseEscape(InputSource inputSource) throws IOException, JSONException {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        block8: while ((n3 = inputSource.next()) != -1) {
            int n4;
            char c = (char)n3;
            if (c == '\ufeff') continue;
            if (n == 0) {
                if (c == '\\') {
                    n = 1;
                    continue;
                }
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
            }
            if (n == 1) {
                switch (c) {
                    case 'b': {
                        n2 = 8;
                        break;
                    }
                    case 'f': {
                        n2 = 12;
                        break;
                    }
                    case 'n': {
                        n2 = 10;
                        break;
                    }
                    case 'r': {
                        n2 = 13;
                        break;
                    }
                    case 't': {
                        n2 = 9;
                        break;
                    }
                    case 'u': {
                        n = 2;
                        continue block8;
                    }
                    default: {
                        n2 = c;
                        break;
                    }
                }
                break;
            }
            int n5 = c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : (n4 = c >= 'a' && c <= 'f' ? c - 97 + 10 : -1));
            if (n4 != -1) {
                n2 = (char)(n2 | n4 << (5 - n) * 4);
                if (n == 5) break;
                ++n;
                continue;
            }
            throw this.createParseException(this.getMessage("json.parse.IllegalUnicodeEscape", Character.valueOf(c)), inputSource);
        }
        return (char)n2;
    }

    private void skipComment(Context context, InputSource inputSource) throws IOException, JSONException {
        int n = 0;
        int n2 = -1;
        block7: while ((n2 = inputSource.next()) != -1) {
            char c = (char)n2;
            switch (c) {
                case '\ufeff': {
                    continue block7;
                }
                case '/': {
                    if (n == 0) {
                        n = 1;
                        continue block7;
                    }
                    if (n == 1) {
                        n = 4;
                        continue block7;
                    }
                    if (n == 3) break block7;
                    if (n == 2 || n == 4) continue block7;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
                case '*': {
                    if (n == 1) {
                        n = 2;
                        continue block7;
                    }
                    if (n == 2) {
                        n = 3;
                        continue block7;
                    }
                    if (n == 3 || n == 4) continue block7;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
                case '\n': 
                case '\r': {
                    if (n == 2 || n == 3) {
                        n = 2;
                        continue block7;
                    }
                    if (n == 4) break block7;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
                case '#': {
                    if (context.getMode() == Mode.TRADITIONAL) {
                        if (n == 0) {
                            n = 4;
                            continue block7;
                        }
                        if (n == 3) {
                            n = 2;
                            continue block7;
                        }
                        if (n == 2 || n == 4) continue block7;
                        throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                    }
                }
                default: {
                    if (n == 3) {
                        n = 2;
                        continue block7;
                    }
                    if (n == 2 || n == 4) continue block7;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), inputSource);
                }
            }
        }
    }

    JSONException createParseException(String string, InputSource inputSource) {
        return new JSONException("" + inputSource.getLineNumber() + ": " + string + "\n" + inputSource.toString() + " <- ?", 200, inputSource.getLineNumber(), inputSource.getColumnNumber(), inputSource.getOffset());
    }

    String getMessage(String string, Object ... objectArray) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("net.arnx.jsonic.Messages", this.locale);
        return MessageFormat.format(resourceBundle.getString(string), objectArray);
    }

    public Object convert(Object object, Type type) throws JSONException {
        return this.convert(new Context(), object, type);
    }

    private <T> T convert(Context context, Object object, Type type) throws JSONException {
        Class<?> clazz = ClassUtil.getRawType(type);
        T t2 = null;
        try {
            context.enter(Character.valueOf('$'));
            t2 = (T)this.postparse(context, object, clazz, type);
            context.exit();
        }
        catch (Exception exception) {
            String string;
            if (object instanceof CharSequence) {
                string = "\"" + object + "\"";
            } else {
                try {
                    string = object.toString();
                }
                catch (Exception exception2) {
                    string = object.getClass().toString();
                }
            }
            throw new JSONException(this.getMessage("json.parse.ConversionError", string, type, context), 250, exception);
        }
        return t2;
    }

    protected <T> T postparse(Context context, Object object, Class<? extends T> clazz, Type type) throws Exception {
        Converter converter = null;
        if (object == null) {
            if (!clazz.isPrimitive()) {
                converter = NullConverter.INSTANCE;
            }
        } else {
            JSONHint jSONHint = context.getHint();
            if (jSONHint != null) {
                if (jSONHint.serialized() && jSONHint != context.skipHint) {
                    converter = FormatConverter.INSTANCE;
                } else if (Serializable.class.equals(jSONHint.type())) {
                    converter = SerializableConverter.INSTANCE;
                } else if (String.class.equals(jSONHint.type())) {
                    converter = StringSerializableConverter.INSTANCE;
                }
            }
        }
        if (converter == null) {
            converter = object != null && clazz.equals(type) && clazz.isAssignableFrom(object.getClass()) ? PlainConverter.INSTANCE : CONVERT_MAP.get(clazz);
        }
        if (converter == null) {
            converter = context.hasMemberCache(clazz) ? ObjectConverter.INSTANCE : (Properties.class.isAssignableFrom(clazz) ? PropertiesConverter.INSTANCE : (Map.class.isAssignableFrom(clazz) ? MapConverter.INSTANCE : (Collection.class.isAssignableFrom(clazz) ? CollectionConverter.INSTANCE : (clazz.isArray() ? ArrayConverter.INSTANCE : (clazz.isEnum() ? EnumConverter.INSTANCE : (Date.class.isAssignableFrom(clazz) ? DateConverter.INSTANCE : (Calendar.class.isAssignableFrom(clazz) ? CalendarConverter.INSTANCE : (CharSequence.class.isAssignableFrom(clazz) ? CharSequenceConverter.INSTANCE : (Appendable.class.isAssignableFrom(clazz) ? AppendableConverter.INSTANCE : (clazz.equals(ClassUtil.findClass("java.net.InetAddress")) ? InetAddressConverter.INSTANCE : (Array.class.isAssignableFrom(clazz) || Struct.class.isAssignableFrom(clazz) ? NullConverter.INSTANCE : ObjectConverter.INSTANCE)))))))))));
        }
        if (converter != null) {
            return (T)converter.convert(this, context, object, clazz, type);
        }
        throw new UnsupportedOperationException();
    }

    protected String normalize(String string) {
        return string;
    }

    protected boolean ignore(Context context, Class<?> clazz, Member member) {
        if (Modifier.isTransient(member.getModifiers())) {
            return true;
        }
        return member.getDeclaringClass().equals(Object.class);
    }

    protected <T> T create(Context context, Class<? extends T> clazz) throws Exception {
        Serializable serializable = null;
        JSONHint jSONHint = context.getHint();
        if (jSONHint != null && jSONHint.type() != Object.class) {
            clazz = jSONHint.type().asSubclass(clazz);
        }
        if (clazz.isInterface()) {
            if (SortedMap.class.equals(clazz)) {
                serializable = new TreeMap();
            } else if (Map.class.equals(clazz)) {
                serializable = new LinkedHashMap();
            } else if (SortedSet.class.equals(clazz)) {
                serializable = new TreeSet();
            } else if (Set.class.equals(clazz)) {
                serializable = new LinkedHashSet();
            } else if (List.class.equals(clazz)) {
                serializable = new ArrayList();
            } else if (Collection.class.equals(clazz)) {
                serializable = new ArrayList();
            } else if (Appendable.class.equals(clazz)) {
                serializable = new StringBuilder();
            }
        } else if (Modifier.isAbstract(clazz.getModifiers())) {
            if (Calendar.class.equals(clazz)) {
                serializable = Calendar.getInstance();
            }
        } else if ((clazz.isMemberClass() || clazz.isAnonymousClass()) && !Modifier.isStatic(clazz.getModifiers())) {
            Class<?> clazz2 = clazz.getEnclosingClass();
            Constructor<T> constructor = clazz.getDeclaredConstructor(clazz2);
            constructor.setAccessible(true);
            serializable = context.contextObject != null && clazz2.isAssignableFrom(context.contextObject.getClass()) ? constructor.newInstance(context.contextObject) : constructor.newInstance(new Object[]{null});
        } else {
            Constructor<T> constructor;
            if (Date.class.isAssignableFrom(clazz)) {
                try {
                    constructor = clazz.getDeclaredConstructor(Long.TYPE);
                    constructor.setAccessible(true);
                    serializable = constructor.newInstance(0L);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (serializable == null) {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                serializable = constructor.newInstance(new Object[0]);
            }
        }
        return clazz.cast(serializable);
    }

    private static boolean isAssignableFrom(Class<?> clazz, Class<?> clazz2) {
        return clazz != null && clazz.isAssignableFrom(clazz2);
    }

    static {
        FORMAT_MAP.put(Boolean.TYPE, PlainFormatter.INSTANCE);
        FORMAT_MAP.put(Character.TYPE, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Byte.TYPE, ByteFormatter.INSTANCE);
        FORMAT_MAP.put(Short.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Integer.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Long.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Float.TYPE, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(Double.TYPE, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(boolean[].class, BooleanArrayFormatter.INSTANCE);
        FORMAT_MAP.put(char[].class, CharArrayFormatter.INSTANCE);
        FORMAT_MAP.put(byte[].class, ByteArrayFormatter.INSTANCE);
        FORMAT_MAP.put(short[].class, ShortArrayFormatter.INSTANCE);
        FORMAT_MAP.put(int[].class, IntArrayFormatter.INSTANCE);
        FORMAT_MAP.put(long[].class, LongArrayFormatter.INSTANCE);
        FORMAT_MAP.put(float[].class, FloatArrayFormatter.INSTANCE);
        FORMAT_MAP.put(double[].class, DoubleArrayFormatter.INSTANCE);
        FORMAT_MAP.put(Object[].class, ObjectArrayFormatter.INSTANCE);
        FORMAT_MAP.put(Boolean.class, PlainFormatter.INSTANCE);
        FORMAT_MAP.put(Character.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Byte.class, ByteFormatter.INSTANCE);
        FORMAT_MAP.put(Short.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Integer.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Long.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Float.class, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(Double.class, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(BigInteger.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(BigDecimal.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(String.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Date.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(java.sql.Date.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(Time.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(Timestamp.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(URI.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(URL.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(UUID.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Pattern.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Class.class, ClassFormatter.INSTANCE);
        FORMAT_MAP.put(Locale.class, LocaleFormatter.INSTANCE);
        FORMAT_MAP.put(ArrayList.class, ListFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedList.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(HashSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(TreeSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedHashSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(HashMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(IdentityHashMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(Properties.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(TreeMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedHashMap.class, MapFormatter.INSTANCE);
        CONVERT_MAP.put(Boolean.TYPE, BooleanConverter.INSTANCE);
        CONVERT_MAP.put(Character.TYPE, CharacterConverter.INSTANCE);
        CONVERT_MAP.put(Byte.TYPE, ByteConverter.INSTANCE);
        CONVERT_MAP.put(Short.TYPE, ShortConverter.INSTANCE);
        CONVERT_MAP.put(Integer.TYPE, IntegerConverter.INSTANCE);
        CONVERT_MAP.put(Long.TYPE, LongConverter.INSTANCE);
        CONVERT_MAP.put(Float.TYPE, FloatConverter.INSTANCE);
        CONVERT_MAP.put(Double.TYPE, DoubleConverter.INSTANCE);
        CONVERT_MAP.put(boolean[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(char[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(byte[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(short[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(int[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(long[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(float[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(double[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(Object[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(Boolean.class, BooleanConverter.INSTANCE);
        CONVERT_MAP.put(Character.class, CharacterConverter.INSTANCE);
        CONVERT_MAP.put(Byte.class, ByteConverter.INSTANCE);
        CONVERT_MAP.put(Short.class, ShortConverter.INSTANCE);
        CONVERT_MAP.put(Integer.class, IntegerConverter.INSTANCE);
        CONVERT_MAP.put(Long.class, LongConverter.INSTANCE);
        CONVERT_MAP.put(Float.class, FloatConverter.INSTANCE);
        CONVERT_MAP.put(Double.class, DoubleConverter.INSTANCE);
        CONVERT_MAP.put(BigInteger.class, BigIntegerConverter.INSTANCE);
        CONVERT_MAP.put(BigDecimal.class, BigDecimalConverter.INSTANCE);
        CONVERT_MAP.put(Number.class, BigDecimalConverter.INSTANCE);
        CONVERT_MAP.put(Pattern.class, PatternConverter.INSTANCE);
        CONVERT_MAP.put(TimeZone.class, TimeZoneConverter.INSTANCE);
        CONVERT_MAP.put(Locale.class, LocaleConverter.INSTANCE);
        CONVERT_MAP.put(File.class, FileConverter.INSTANCE);
        CONVERT_MAP.put(URL.class, URLConverter.INSTANCE);
        CONVERT_MAP.put(URI.class, URIConverter.INSTANCE);
        CONVERT_MAP.put(UUID.class, UUIDConverter.INSTANCE);
        CONVERT_MAP.put(Charset.class, CharsetConverter.INSTANCE);
        CONVERT_MAP.put(Class.class, ClassConverter.INSTANCE);
        CONVERT_MAP.put(Date.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(java.sql.Date.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Time.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Timestamp.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Calendar.class, CalendarConverter.INSTANCE);
        CONVERT_MAP.put(Collection.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(Set.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(List.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(SortedSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(LinkedList.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(HashSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(TreeSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(LinkedHashSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(Map.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(SortedMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(HashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(IdentityHashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(TreeMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(LinkedHashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(Properties.class, PropertiesConverter.INSTANCE);
        for (int i = 0; i < 32; ++i) {
            JSON.ESCAPE_CHARS[i] = 1;
        }
        JSON.ESCAPE_CHARS[39] = 2;
        JSON.ESCAPE_CHARS[34] = 2;
        JSON.ESCAPE_CHARS[92] = 3;
        JSON.ESCAPE_CHARS[127] = 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Context {
        private final Locale locale;
        private final TimeZone timeZone;
        private final Object contextObject;
        private final int maxDepth;
        private final boolean prettyPrint;
        private final boolean suppressNull;
        private final Mode mode;
        private final String numberFormat;
        private final String dateFormat;
        private final NamingStyle propertyStyle;
        private final NamingStyle enumStyle;
        private Object[] path;
        private int depth = -1;
        private Map<Class<?>, Object> memberCache;
        private Map<String, DateFormat> dateFormatCache;
        private Map<String, NumberFormat> numberFormatCache;
        private StringBuilder builderCache;
        JSONHint skipHint;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Context() {
            JSON jSON2 = JSON.this;
            synchronized (jSON2) {
                this.locale = JSON.this.locale;
                this.timeZone = JSON.this.timeZone;
                this.contextObject = JSON.this.contextObject;
                this.maxDepth = JSON.this.maxDepth;
                this.prettyPrint = JSON.this.prettyPrint;
                this.suppressNull = JSON.this.suppressNull;
                this.mode = JSON.this.mode;
                this.numberFormat = JSON.this.numberFormat;
                this.dateFormat = JSON.this.dateFormat;
                this.propertyStyle = JSON.this.propertyStyle;
                this.enumStyle = JSON.this.enumStyle;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Context(Context context) {
            Context context2 = context;
            synchronized (context2) {
                this.locale = context.locale;
                this.timeZone = context.timeZone;
                this.contextObject = context.contextObject;
                this.maxDepth = context.maxDepth;
                this.prettyPrint = context.prettyPrint;
                this.suppressNull = context.suppressNull;
                this.mode = context.mode;
                this.numberFormat = context.numberFormat;
                this.dateFormat = context.dateFormat;
                this.propertyStyle = context.propertyStyle;
                this.enumStyle = context.enumStyle;
                this.depth = context.depth;
                this.path = (Object[])context.path.clone();
            }
        }

        public StringBuilder getCachedBuffer() {
            if (this.builderCache == null) {
                this.builderCache = new StringBuilder();
            } else {
                this.builderCache.setLength(0);
            }
            return this.builderCache;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public boolean isPrettyPrint() {
            return this.prettyPrint;
        }

        public boolean isSuppressNull() {
            return this.suppressNull;
        }

        public Mode getMode() {
            return this.mode;
        }

        public NamingStyle getPropertyStyle() {
            return this.propertyStyle;
        }

        public NamingStyle getEnumStyle() {
            return this.enumStyle;
        }

        @Deprecated
        public NamingStyle getPropertyCaseStyle() {
            return this.propertyStyle;
        }

        @Deprecated
        public NamingStyle getEnumCaseStyle() {
            return this.enumStyle;
        }

        @Deprecated
        public int getLevel() {
            return this.depth;
        }

        public int getDepth() {
            return this.depth;
        }

        public Object getKey() {
            return this.path[this.depth * 2];
        }

        public Object getKey(int n) {
            if (n < 0) {
                n = this.getDepth() + n;
            }
            return this.path[n * 2];
        }

        public JSONHint getHint() {
            return (JSONHint)this.path[this.depth * 2 + 1];
        }

        public <T> T convert(Object object, Object object2, Class<? extends T> clazz) throws Exception {
            this.enter(object);
            T t2 = JSON.this.postparse(this, object2, clazz, clazz);
            this.exit();
            return (T)(clazz.isPrimitive() ? PlainConverter.getDefaultValue(clazz).getClass() : clazz).cast(t2);
        }

        public Object convert(Object object, Object object2, Type type) throws Exception {
            Class<?> clazz = ClassUtil.getRawType(type);
            this.enter(object);
            Object obj = JSON.this.postparse(this, object2, clazz, type);
            this.exit();
            return (clazz.isPrimitive() ? PlainConverter.getDefaultValue(clazz).getClass() : clazz).cast(obj);
        }

        void enter(Object object, JSONHint jSONHint) {
            ++this.depth;
            if (this.path == null) {
                this.path = new Object[8];
            }
            if (this.path.length < this.depth * 2 + 2) {
                Object[] objectArray = new Object[Math.max(this.path.length * 2, this.depth * 2 + 2)];
                System.arraycopy(this.path, 0, objectArray, 0, this.path.length);
                this.path = objectArray;
            }
            this.path[this.depth * 2] = object;
            this.path[this.depth * 2 + 1] = jSONHint;
        }

        void enter(Object object) {
            this.enter(object, (JSONHint)(this.depth != -1 ? this.path[this.depth * 2 + 1] : null));
        }

        void exit() {
            --this.depth;
        }

        boolean hasMemberCache(Class<?> clazz) {
            return this.memberCache != null && this.memberCache.containsKey(clazz);
        }

        List<PropertyInfo> getGetProperties(Class<?> clazz) {
            ArrayList arrayList;
            if (this.memberCache == null) {
                this.memberCache = new HashMap();
            }
            if ((arrayList = (ArrayList)this.memberCache.get(clazz)) == null) {
                int n;
                String string;
                JSONHint jSONHint;
                AccessibleObject accessibleObject;
                HashMap<String, PropertyInfo> hashMap = new HashMap<String, PropertyInfo>();
                for (PropertyInfo propertyInfo : BeanInfo.get(clazz).getProperties()) {
                    accessibleObject = propertyInfo.getField();
                    if (accessibleObject == null || JSON.this.ignore(this, clazz, (Member)((Object)accessibleObject))) continue;
                    jSONHint = ((Field)accessibleObject).getAnnotation(JSONHint.class);
                    string = null;
                    n = propertyInfo.getOrdinal();
                    if (jSONHint != null) {
                        if (jSONHint.ignore()) continue;
                        n = jSONHint.ordinal();
                        if (jSONHint.name().length() != 0) {
                            string = jSONHint.name();
                        }
                    }
                    if (string == null) {
                        string = JSON.this.normalize(propertyInfo.getName());
                        if (this.getPropertyStyle() != null) {
                            string = this.getPropertyStyle().to(string);
                        }
                    }
                    if (!string.equals(propertyInfo.getName()) || n != propertyInfo.getOrdinal() || accessibleObject != propertyInfo.getReadMember()) {
                        hashMap.put(string, new PropertyInfo(propertyInfo.getBeanClass(), string, propertyInfo.getField(), null, null, propertyInfo.isStatic(), n));
                        continue;
                    }
                    hashMap.put(string, propertyInfo);
                }
                for (PropertyInfo propertyInfo : BeanInfo.get(clazz).getProperties()) {
                    accessibleObject = propertyInfo.getReadMethod();
                    if (accessibleObject == null || JSON.this.ignore(this, clazz, (Member)((Object)accessibleObject))) continue;
                    jSONHint = ((Method)accessibleObject).getAnnotation(JSONHint.class);
                    string = null;
                    n = propertyInfo.getOrdinal();
                    if (jSONHint != null) {
                        if (jSONHint.ignore()) continue;
                        n = jSONHint.ordinal();
                        if (jSONHint.name().length() != 0) {
                            string = jSONHint.name();
                        }
                    }
                    if (string == null) {
                        string = JSON.this.normalize(propertyInfo.getName());
                        if (this.getPropertyStyle() != null) {
                            string = this.getPropertyStyle().to(string);
                        }
                    }
                    if (!string.equals(propertyInfo.getName()) || n != propertyInfo.getOrdinal()) {
                        hashMap.put(string, new PropertyInfo(propertyInfo.getBeanClass(), string, null, propertyInfo.getReadMethod(), null, propertyInfo.isStatic(), n));
                        continue;
                    }
                    hashMap.put(string, propertyInfo);
                }
                arrayList = new ArrayList(hashMap.values());
                Collections.sort(arrayList);
                this.memberCache.put(clazz, arrayList);
            }
            return arrayList;
        }

        Map<String, PropertyInfo> getSetProperties(Class<?> clazz) {
            HashMap<String, PropertyInfo> hashMap;
            if (this.memberCache == null) {
                this.memberCache = new HashMap();
            }
            if ((hashMap = (HashMap<String, PropertyInfo>)this.memberCache.get(clazz)) == null) {
                int n;
                String string;
                JSONHint jSONHint;
                AccessibleObject accessibleObject;
                HashMap<String, PropertyInfo> hashMap2 = new HashMap<String, PropertyInfo>();
                for (PropertyInfo propertyInfo : BeanInfo.get(clazz).getProperties()) {
                    accessibleObject = propertyInfo.getField();
                    if (accessibleObject == null || Modifier.isFinal(((Field)accessibleObject).getModifiers()) || JSON.this.ignore(this, clazz, (Member)((Object)accessibleObject))) continue;
                    jSONHint = ((Field)accessibleObject).getAnnotation(JSONHint.class);
                    string = null;
                    n = propertyInfo.getOrdinal();
                    if (jSONHint != null) {
                        if (jSONHint.ignore()) continue;
                        n = jSONHint.ordinal();
                        if (jSONHint.name().length() != 0) {
                            string = jSONHint.name();
                        }
                    }
                    if (string == null) {
                        string = JSON.this.normalize(propertyInfo.getName());
                        if (this.getPropertyStyle() != null) {
                            string = this.getPropertyStyle().to(string);
                        }
                    }
                    if (!string.equals(propertyInfo.getName()) || n != propertyInfo.getOrdinal() || accessibleObject != propertyInfo.getWriteMember()) {
                        hashMap2.put(string, new PropertyInfo(propertyInfo.getBeanClass(), string, propertyInfo.getField(), null, null, propertyInfo.isStatic(), n));
                        continue;
                    }
                    hashMap2.put(string, propertyInfo);
                }
                for (PropertyInfo propertyInfo : BeanInfo.get(clazz).getProperties()) {
                    accessibleObject = propertyInfo.getWriteMethod();
                    if (accessibleObject == null || JSON.this.ignore(this, clazz, (Member)((Object)accessibleObject))) continue;
                    jSONHint = ((Method)accessibleObject).getAnnotation(JSONHint.class);
                    string = null;
                    n = propertyInfo.getOrdinal();
                    if (jSONHint != null) {
                        if (jSONHint.ignore()) continue;
                        n = jSONHint.ordinal();
                        if (jSONHint.name().length() != 0) {
                            string = jSONHint.name();
                        }
                    }
                    if (string == null) {
                        string = JSON.this.normalize(propertyInfo.getName());
                        if (this.getPropertyStyle() != null) {
                            string = this.getPropertyStyle().to(string);
                        }
                    }
                    if (!string.equals(propertyInfo.getName()) || n != propertyInfo.getOrdinal()) {
                        hashMap2.put(string, new PropertyInfo(propertyInfo.getBeanClass(), string, null, null, propertyInfo.getWriteMethod(), propertyInfo.isStatic(), n));
                        continue;
                    }
                    hashMap2.put(string, propertyInfo);
                }
                hashMap = hashMap2;
                this.memberCache.put(clazz, hashMap);
            }
            return hashMap;
        }

        NumberFormat getNumberFormat() {
            String string;
            JSONHint jSONHint = this.getHint();
            String string2 = string = jSONHint != null && jSONHint.format().length() > 0 ? jSONHint.format() : this.numberFormat;
            if (string != null) {
                NumberFormat numberFormat = null;
                if (this.numberFormatCache == null) {
                    this.numberFormatCache = new HashMap<String, NumberFormat>();
                } else {
                    numberFormat = this.numberFormatCache.get(string);
                }
                if (numberFormat == null) {
                    numberFormat = new DecimalFormat(string, new DecimalFormatSymbols(this.locale));
                    this.numberFormatCache.put(string, numberFormat);
                }
                return numberFormat;
            }
            return null;
        }

        DateFormat getDateFormat() {
            String string;
            JSONHint jSONHint = this.getHint();
            String string2 = string = jSONHint != null && jSONHint.format().length() > 0 ? jSONHint.format() : this.dateFormat;
            if (string != null) {
                DateFormat dateFormat = null;
                if (this.dateFormatCache == null) {
                    this.dateFormatCache = new HashMap<String, DateFormat>();
                } else {
                    dateFormat = this.dateFormatCache.get(string);
                }
                if (dateFormat == null) {
                    dateFormat = new ExtendedDateFormat(string, this.locale);
                    dateFormat.setTimeZone(this.timeZone);
                    this.dateFormatCache.put(string, dateFormat);
                }
                return dateFormat;
            }
            return null;
        }

        public String toString() {
            StringBuilderOutputSource stringBuilderOutputSource = new StringBuilderOutputSource(this.getCachedBuffer());
            for (int i = 0; i < this.path.length; i += 2) {
                Object object = this.path[i];
                if (object == null) {
                    stringBuilderOutputSource.append("[null]");
                    continue;
                }
                if (object instanceof Number) {
                    stringBuilderOutputSource.append('[');
                    stringBuilderOutputSource.append(object.toString());
                    stringBuilderOutputSource.append(']');
                    continue;
                }
                if (object instanceof Character) {
                    stringBuilderOutputSource.append(object.toString());
                    continue;
                }
                String string = object.toString();
                boolean bl = false;
                for (int j = 0; j < string.length(); ++j) {
                    if (j == 0) {
                        bl = !Character.isJavaIdentifierStart(string.charAt(j));
                    } else {
                        boolean bl2 = bl = !Character.isJavaIdentifierPart(string.charAt(j));
                    }
                    if (bl) break;
                }
                if (bl) {
                    stringBuilderOutputSource.append('[');
                    try {
                        StringFormatter.serialize(this, string, stringBuilderOutputSource);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    stringBuilderOutputSource.append(']');
                    continue;
                }
                stringBuilderOutputSource.append('.');
                stringBuilderOutputSource.append(string);
            }
            return stringBuilderOutputSource.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        TRADITIONAL,
        STRICT,
        SCRIPT;

    }
}

