/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.nio.ByteBuffer;

public class MLUInt8
extends MLNumericArray<Byte> {
    public MLUInt8(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public MLUInt8(String name, int[] dims) {
        super(name, dims, 9, 0);
    }

    public MLUInt8(String name, Byte[] vals, int m4) {
        super(name, 9, (Number[])vals, m4);
    }

    public MLUInt8(String name, byte[][] vals) {
        this(name, MLUInt8.byte2DToByte(vals), vals.length);
    }

    public MLUInt8(String name, byte[] vals, int m4) {
        this(name, MLUInt8.castToByte(vals), m4);
    }

    public Byte[] createArray(int m4, int n) {
        return new Byte[m4 * n];
    }

    public byte[][] getArray() {
        byte[][] result = new byte[this.getM()][];
        for (int m4 = 0; m4 < this.getM(); ++m4) {
            result[m4] = new byte[this.getN()];
            for (int n = 0; n < this.getN(); ++n) {
                result[m4][n] = (Byte)this.getReal(m4, n);
            }
        }
        return result;
    }

    private static Byte[] castToByte(byte[] d) {
        Byte[] dest = new Byte[d.length];
        for (int i = 0; i < d.length; ++i) {
            dest[i] = d[i];
        }
        return dest;
    }

    private static Byte[] byte2DToByte(byte[][] dd) {
        Byte[] d = new Byte[dd.length * dd[0].length];
        for (int n = 0; n < dd[0].length; ++n) {
            for (int m4 = 0; m4 < dd.length; ++m4) {
                d[m4 + n * dd.length] = dd[m4][n];
            }
        }
        return d;
    }

    @Override
    public Byte buldFromBytes(byte[] bytes) {
        if (bytes.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return bytes[0];
    }

    @Override
    public byte[] getByteArray(Byte value) {
        return new byte[]{value};
    }

    @Override
    public int getBytesAllocated() {
        return 1;
    }

    @Override
    public Class<Byte> getStorageClazz() {
        return Byte.class;
    }

    @Override
    protected Byte get(ByteBuffer buffer, int index) {
        return buffer.get(index);
    }
}

