/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.nio.ByteBuffer;

public class MLUInt64
extends MLNumericArray<Long> {
    public MLUInt64(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public MLUInt64(String name, int[] dims) {
        super(name, dims, 15, 0);
    }

    public MLUInt64(String name, Long[] vals, int m4) {
        super(name, 15, (Number[])vals, m4);
    }

    public MLUInt64(String name, long[][] vals) {
        this(name, MLUInt64.long2DToLong(vals), vals.length);
    }

    public MLUInt64(String name, long[] vals, int m4) {
        this(name, MLUInt64.castToLong(vals), m4);
    }

    public long[][] getArray() {
        long[][] result = new long[this.getM()][];
        for (int m4 = 0; m4 < this.getM(); ++m4) {
            result[m4] = new long[this.getN()];
            for (int n = 0; n < this.getN(); ++n) {
                result[m4][n] = (Long)this.getReal(m4, n);
            }
        }
        return result;
    }

    private static Long[] castToLong(long[] d) {
        Long[] dest = new Long[d.length];
        for (int i = 0; i < d.length; ++i) {
            dest[i] = d[i];
        }
        return dest;
    }

    private static Long[] long2DToLong(long[][] dd) {
        Long[] d = new Long[dd.length * dd[0].length];
        for (int n = 0; n < dd[0].length; ++n) {
            for (int m4 = 0; m4 < dd.length; ++m4) {
                d[m4 + n * dd.length] = dd[m4][n];
            }
        }
        return d;
    }

    @Override
    public Long buldFromBytes(byte[] bytes) {
        if (bytes.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return ByteBuffer.wrap(bytes).getLong();
    }

    @Override
    public int getBytesAllocated() {
        return 8;
    }

    @Override
    public Class<Long> getStorageClazz() {
        return Long.class;
    }

    @Override
    public byte[] getByteArray(Long value) {
        int byteAllocated = this.getBytesAllocated();
        ByteBuffer buff = ByteBuffer.allocate(byteAllocated);
        buff.putLong(value);
        return buff.array();
    }
}

