<?php

declare(strict_types=1);

namespace Inside\Workflow\Providers;

use Inside\Content\Events\ContentDeletedEvent;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\Content\Events\ContentPublishedEvent;
use Inside\Notify\Events\NotificationCreatedEvent;
use Inside\Support\EventServiceProvider;
use Inside\Workflow\Console\CleanProposalStepsCommand;
use Inside\Workflow\Contracts\Workflow as WorkflowContract;
use Inside\Workflow\Events\ProposalEditedEvent;
use Inside\Workflow\Events\ProposalReviewedEvent;
use Inside\Workflow\Http\Middlewares\WorkflowContentFormMiddleware;
use Inside\Workflow\Http\Middlewares\WorkflowRelatedContentMiddleware;
use Inside\Workflow\Listeners\ContentDeletedListener;
use Inside\Workflow\Listeners\ContentInsertedListener;
use Inside\Workflow\Listeners\ContentPublishedListener;
use Inside\Workflow\Listeners\ContentUpdatedListener;
use Inside\Workflow\Listeners\NotificationCreatedListener;
use Inside\Workflow\Listeners\ProposalEditedListener;
use Inside\Workflow\Listeners\ProposalReviewedListener;
use Inside\Workflow\Services\ProposalService;
use Inside\Workflow\Services\WorkflowService;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

final class WorkflowServiceProvider extends EventServiceProvider
{
    protected array $listen = [
        ContentFullyInsertedEvent::class => [
            ContentInsertedListener::class,
        ],
        ContentFullyUpdatedEvent::class => [
            ContentUpdatedListener::class,
        ],
        ContentDeletedEvent::class => [
            ContentDeletedListener::class,
        ],
        ContentPublishedEvent::class => [
            ContentPublishedListener::class,
        ],
        NotificationCreatedEvent::class => [
            NotificationCreatedListener::class,
        ],
        ProposalEditedEvent::class => [
            ProposalEditedListener::class,
        ],
        ProposalReviewedEvent::class => [
            ProposalReviewedListener::class,
        ],
    ];

    public array $bindings = [
        'workflow.proposal' => ProposalService::class,
    ];

    public array $singletons = [
        WorkflowContract::class => WorkflowService::class,
    ];

    protected array $commands = [
        CleanProposalStepsCommand::class,
    ];

    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../../config/workflow.php', 'workflow');
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/contents.php', 'contents');
        } catch (NotFoundExceptionInterface | ContainerExceptionInterface) {
        }

        $this->app->middleware([
            WorkflowContentFormMiddleware::class,
        ]);

        $this->app->routeMiddleware(
            [
                'workflow.related.contents' => WorkflowRelatedContentMiddleware::class,
            ]
        );
    }
}
