<?php

namespace Inside\Workflow\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Collection;
use Inside\Permission\Models\Role;

/**
 * @property int $id
 * @property string $step_type
 * @property Collection<Role> $reviewers
 * @property string $title
 * @property bool $send_mail
 */
class WorkflowStep extends Model
{
    /**
     * The table without the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_workflow_steps';

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * The attributes that are fillable
     *
     * @var array
     */
    protected $fillable = [
        'workflow_id',
        'title',
        'send_mail',
        'step_type',
    ];

    public static function boot()
    {
        parent::boot();
    }

    /**
     * @return BelongsToMany
     */
    public function reviewers(): BelongsToMany
    {
        return $this->belongsToMany(
            Role::class,
            'inside_reviewers_workflow_steps',
            'workflow_step_id',
            'role_id'
        );
    }
}
