<?php

namespace Inside\Workflow\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static null|static find($id, $columns = ['*'])
 * @method static static|null first(array $columns = ['*'])
 *
 * @property int $id
 * @property int $updated_at
 * @property ProposalCycle $cycle
 * @property WorkflowStep $workflowStep
 * @property string $reviewer_uuid
 * @property bool $validated
 * @property string $user_uuid
 * @property string $review
 */
class ProposalStep extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_workflow_proposal_steps';

    /**
     * Casts the following attributes
     *
     * @var array
     */
    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
    ];

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * The attributes that are fillable
     *
     * @var array
     */
    protected $fillable = [
        'step_id',
        'user_uuid',
        'reviewer_uuid',
        'review',
        'validated',
    ];

    public static function boot()
    {
        parent::boot();
    }

    /**
     * Get cycle for this entity
     *
     * @return BelongsTo
     */
    public function cycle(): BelongsTo
    {
        return $this->belongsTo(
            ProposalCycle::class,
            'cycle_id'
        );
    }

    /**
     * Get workflow step for this entity
     *
     * @return BelongsTo
     */
    public function workflowStep(): BelongsTo
    {
        return $this->belongsTo(
            WorkflowStep::class,
            'step_id'
        );
    }
}
