<?php

namespace Inside\Workflow\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property int $id
 * @property Proposal $proposal
 * @property Collection<ProposalStep> $steps
 */
class ProposalCycle extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_workflow_proposal_cycles';

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $guarded = ['id'];

    public static function boot()
    {
        parent::boot();
    }

    /**
     * Get proposal for this cycle
     *
     * @return BelongsTo
     */
    public function proposal(): BelongsTo
    {
        return $this->belongsTo(
            Proposal::class,
            'proposal_id'
        );
    }

    /**
     * Get steps for this entity
     *
     * @return HasMany
     */
    public function steps(): HasMany
    {
        return $this->hasMany(
            ProposalStep::class,
            'cycle_id'
        );
    }
}
