<?php

declare(strict_types=1);

namespace Inside\Workflow\Listeners;

use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Models\Section;
use Inside\Workflow\Events\ProposalEditedEvent;
use Inside\Workflow\Facades\Proposal;
use Inside\Workflow\Facades\Workflow;

final class ContentInsertedListener
{
    public function handle(ContentFullyInsertedEvent $event): void
    {
        if (! Workflow::isWorkflowEnable()) {
            return;
        }
        $model = $event->model;

        if ($model instanceof Section) {
            return;
        }

        if (Proposal::bypassWorkflow($model)) {
            return;
        }

        // For declined content we attach the workflow proposal at the edition
        if (Proposal::isContentDeclined($model)) {
            return;
        }

        // A content has been created, we attach the related workflow if exist
        $proposal = Proposal::attachToContent($model);

        // If workflow attached we depublish the content
        // the publication will be done by the workflow
        // We also trigger the proposal edited event
        if ($proposal && ! Proposal::bypassWorkflow($model)) {
            ProposalEditedEvent::dispatch($proposal, $model);

            if ($model->status !== 0) {
                Proposal::editContentStatus($model, false);
            }
        }
    }
}
