<?php

namespace Inside\Workflow\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Workflow\Facades\Proposal;
use Laravel\Lumen\Routing\Controller;

class ProposalController extends Controller
{
    public function editStep(Request $request, int $id): JsonResponse
    {
        $data = $request->only(
            'user_uuid',
            'reviewer_uuid',
            'review',
            'validated'
        );
        $proposal = Proposal::editStep($id, $data);

        return response()->json($proposal->toArray() ?? []);
    }
}
