<?php

declare(strict_types=1);

namespace Inside\Workflow\Facades;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Facade;
use Inside\Workflow\Contracts\Workflow as WorkflowContract;
use Inside\Workflow\Models\Workflow as WorkflowModel;

/**
 * @method static Collection<WorkflowModel> list()
 * @method static WorkflowModel|null get(int $id)
 * @method static WorkflowModel create(array $data)
 * @method static WorkflowModel|null update(int $id, array $data)
 * @method static void delete(int $id)
 * @method static bool isContentInWorkflow(array|string $contentTypes)
 * @method static mixed withoutWorkflow(\Closure $callback)
 * @method static bool isWorkflowEnable()
 * @method static void enableWorkflow()
 * @method static void disableWorkflow()
 */
final class Workflow extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return WorkflowContract::class;
    }
}
