<?php

namespace Inside\Workflow\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;
use Inside\Events\Dispatchable;
use Inside\Workflow\Models\Proposal;
use Inside\Workflow\Models\ProposalStep;

/**
 * Workflow proposal event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class BaseProposalEvent implements ShouldBroadcast
{
    use InteractsWithSockets, SerializesModels, Dispatchable;

    /**
     * @var array<string, ?ProposalStep>
     */
    public array $steps;

    public ?User $user;

    /**
     * @param Proposal $proposal
     * @param Content $proposable
     */
    public function __construct(
        public Proposal $proposal,
        public Content $proposable
    ) {
        /** @var User $user */
        $user = Auth::user();

        $this->user = $user;
        $this->steps = [
            'previous' => \Inside\Workflow\Facades\Proposal::getPreviousStep($proposal->id),
            'current' => \Inside\Workflow\Facades\Proposal::getCurrentStep($proposal->id) ?? false,
            'next' => \Inside\Workflow\Facades\Proposal::getNextStep($proposal->id),
        ];
    }

    public function broadcastOn(): Channel
    {
        return new Channel('inside.workflow.proposal');
    }
}
