<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Inside\Workflow\Models\Workflow;
use Inside\Workflow\Models\WorkflowStep;

class AddSendMailToWorkflowTables extends Migration
{
    public function up(): void
    {
        if (Schema::hasColumn('inside_workflows', 'send_mail')) {
            return;
        }

        Schema::table('inside_workflows', function (Blueprint $table) {
            $table->boolean('send_mail')->after('contents')->default(false);
        });

        $workflows = Workflow::all();

        foreach ($workflows as $workflow) {
            if (in_array('email', json_decode($workflow->notified_roles_alerts_type, true))) {
                DB::table('inside_workflows')->where('id', $workflow->id)->update(['send_mail' => true]);
            }
        }

        Schema::table('inside_workflow_steps', function (Blueprint $table) {
            $table->boolean('send_mail')->after('title')->default(false);
        });

        $steps = WorkflowStep::all();

        foreach ($steps as $step) {
            if (in_array('email', json_decode($step->alerts_type, true))) {
                DB::table('inside_workflow_steps')->where('id', $step->id)->update(['send_mail' => true]);
            }
        }

        Schema::table('inside_workflows', function (Blueprint $table) {
            $table->dropColumn('notified_roles_alerts_type');
        });

        Schema::table('inside_workflow_steps', function (Blueprint $table) {
            $table->dropColumn('alerts_type');
        });
    }
}
