<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class CreateWorkflowNotificationTypes extends Migration
{
    public function up(): void
    {
        if (NotificationType::query()->where('type', 'workflow')->exists()) {
            return;
        }

        NotificationType::firstOrCreate(
            [
                'via'      => 'email',
                'default'  => false,
                'event'    => 'Inside\Workflow\Events\ProposalEdited',
                'model'    => 'Inside\Workflow\Models\Proposal',
                'action'   => 'edit',
                'type'     => 'workflow',
                'multiple' => false,
                'language' => false,
                'profile'  => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.workflow.proposals.edited.title',
                    'description' => 'notifications.workflow.proposals.edited.description',
                    'mail'        => [
                        'subject'    => 'notifications.workflow.proposals.edited.mail.subject',
                        'text'       => 'notifications.workflow.proposals.edited.mail.content',
                        'buttonText' => 'notifications.workflow.proposals.edited.mail.buttonText',
                    ],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'      => 'web',
                'default'  => false,
                'event'    => 'Inside\Workflow\Events\ProposalEdited',
                'model'    => 'Inside\Workflow\Models\Proposal',
                'action'   => 'edit',
                'type'     => 'system',
                'multiple' => false,
                'language' => false,
                'profile'  => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.workflow.proposals.edited.title',
                    'description' => 'notifications.workflow.proposals.edited.description',
                    'icon'        => 'workflows',
                    'text'        => 'notifications.workflow.proposals.edited.text',
                    'fields'      => [
                        'title',
                    ],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'      => 'email',
                'default'  => false,
                'event'    => 'Inside\Workflow\Events\ProposalReviewed',
                'model'    => 'Inside\Workflow\Models\Proposal',
                'action'   => 'accept',
                'type'     => 'workflow',
                'multiple' => false,
                'language' => false,
                'profile'  => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.workflow.proposals.accepted.title',
                    'description' => 'notifications.workflow.proposals.accepted.description',
                    'mail'        => [
                        'subject'    => 'notifications.workflow.proposals.accepted.mail.subject',
                        'text'       => 'notifications.workflow.proposals.accepted.mail.content',
                        'buttonText' => 'notifications.workflow.proposals.accepted.mail.buttonText',
                    ],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'      => 'web',
                'default'  => false,
                'event'    => 'Inside\Workflow\Events\ProposalReviewed',
                'model'    => 'Inside\Workflow\Models\Proposal',
                'action'   => 'accept',
                'type'     => 'system',
                'multiple' => false,
                'language' => false,
                'profile'  => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.workflow.proposals.accepted.title',
                    'description' => 'notifications.workflow.proposals.accepted.description',
                    'icon'        => 'workflows',
                    'text'        => 'notifications.workflow.proposals.accepted.text',
                    'fields'      => [
                        'title',
                    ],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'      => 'email',
                'default'  => false,
                'event'    => 'Inside\Workflow\Events\ProposalReviewed',
                'model'    => 'Inside\Workflow\Models\Proposal',
                'action'   => 'decline',
                'type'     => 'workflow',
                'multiple' => false,
                'language' => false,
                'profile'  => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.workflow.proposals.declined.title',
                    'description' => 'notifications.workflow.proposals.declined.description',
                    'mail'        => [
                        'subject'    => 'notifications.workflow.proposals.declined.mail.subject',
                        'text'       => 'notifications.workflow.proposals.declined.mail.content',
                        'buttonText' => 'notifications.workflow.proposals.declined.mail.buttonText',
                    ],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'      => 'web',
                'default'  => false,
                'event'    => 'Inside\Workflow\Events\ProposalReviewed',
                'model'    => 'Inside\Workflow\Models\Proposal',
                'action'   => 'decline',
                'type'     => 'system',
                'multiple' => false,
                'language' => false,
                'profile'  => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.workflow.proposals.declined.title',
                    'description' => 'notifications.workflow.proposals.declined.description',
                    'icon'        => 'workflows',
                    'text'        => 'notifications.workflow.proposals.declined.text',
                    'fields'      => [
                        'title',
                    ],
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
