<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWorkflowProposalsTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::dropIfExists('inside_workflow_proposal_steps');
        Schema::dropIfExists('inside_workflow_proposals');

        Schema::create('inside_workflow_proposals', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('workflow_id')->unsigned();
            $table->string('proposable_type', 255)->nullable();
            $table->uuid('proposable_uuid')->nullable();
            $table->tinyInteger('status')->default(2);
            $table->foreign('workflow_id')
                ->references('id')->on('inside_workflows')
                ->onDelete('cascade');
            $table->index(['proposable_uuid', 'proposable_type']);
        });

        Schema::create('inside_workflow_proposal_cycles', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('proposal_id')->unsigned();
            $table->timestamps();
            $table->foreign('proposal_id')
                ->references('id')->on('inside_workflow_proposals')
                ->onDelete('cascade');
        });

        Schema::create('inside_workflow_proposal_steps', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('cycle_id')->unsigned();
            $table->integer('step_id')->unsigned();
            $table->uuid('user_uuid')->nullable();
            $table->uuid('reviewer_uuid')->nullable();
            $table->longText('review');
            $table->boolean('validated');
            $table->timestamps();
            $table->foreign('cycle_id')
                ->references('id')->on('inside_workflow_proposal_cycles')
                ->onDelete('cascade');
            $table->foreign('step_id')
                ->references('id')->on('inside_workflow_steps')
                ->onDelete('cascade');
            $table->foreign('user_uuid')
                ->references('uuid')->on('inside_content_users')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_workflow_proposal_steps');
        Schema::dropIfExists('inside_workflow_proposal_cycles');
        Schema::dropIfExists('inside_workflow_proposals');
    }
}
