<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReviewersWorkflowStepsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('inside_reviewers_workflow_steps', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('role_id')->unsigned();
            $table->integer('workflow_step_id')->unsigned();
            $table->foreign('role_id')
                ->references('id')->on('inside_roles')
                ->onDelete('cascade');
            $table->foreign('workflow_step_id')
                ->references('id')->on('inside_workflow_steps')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_reviewers_workflow_steps');
    }
}
