<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace' => 'Inside\Workflow\Http\Controllers',
        'prefix' => 'api/v1',
        'middleware' => ['auth.backoffice.access:workflow'],
    ],
    function ($router) {
        $router->get(
            'workflow',
            ['uses' => 'WorkflowController@index']
        );

        $router->post(
            'workflow',
            ['uses' => 'WorkflowController@post']
        );

        $router->get(
            'workflow/{id}',
            ['uses' => 'WorkflowController@get']
        );

        $router->put(
            'workflow/{id}',
            ['uses' => 'WorkflowController@put']
        );

        $router->delete(
            'workflow/{id}',
            ['uses' => 'WorkflowController@delete']
        );

        $router->get(
            'workflow/{id}/{status}',
            [
                'uses' => 'WorkflowController@getRelatedContents',
                'middleware' => 'workflow.related.contents',
            ]
        );
    }
);

Route::group(
    [
        'namespace' => 'Inside\Workflow\Http\Controllers',
        'prefix' => 'api/v1',
        'middleware' => ['auth.api'],
    ],
    function ($router) {
        $router->put(
            'workflow/step/{id}',
            ['uses' => 'ProposalController@editStep']
        );
    }
);
