<?php

namespace Inside\Workflow\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @method static static firstOrCreate(array $attributes, array $values = [])
 * @method static null|static find($id, $columns = ['*'])
 * @method static $this where($column, $operator = null, $value = null, $boolean = 'and')
 * @method static static|null first(array $columns = ['*'])
 * @method static int count()
 * @method static $this each($callback)
 *
 * @property int $id
 * @property Workflow $workflow
 * @property int $status
 * @property Collection<ProposalCycle> $cycles
 * @property string $proposable_type
 * @property string $proposable_uuid
 */
class Proposal extends Model
{
    /**
     * The table without the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_workflow_proposals';

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * The attributes that are fillable
     *
     * @var array
     */
    protected $fillable = [
        'workflow_id',
        'proposable_type',
        'proposable_uuid',
    ];

    public static function boot()
    {
        parent::boot();
    }

    /**
     * Get workflow for this entity
     *
     * @return BelongsTo
     */
    public function workflow(): BelongsTo
    {
        return $this->belongsTo(
            Workflow::class,
            'workflow_id'
        );
    }

    /**
     * Get cycles for this entity
     *
     * @return HasMany
     */
    public function cycles(): HasMany
    {
        return $this->hasMany(
            ProposalCycle::class,
            'proposal_id'
        );
    }

    /**
     * Get steps for this entity
     *
     * @return HasMany
     */
    public function steps(): HasMany
    {
        return $this->hasMany(
            ProposalStep::class,
            'cycle_id'
        );
    }

    /**
     * @return mixed
     */
    public function getProposableModelAttribute()
    {
        return call_user_func($this->proposable_type.'::find', $this->proposable_uuid);
    }
}
