<?php

declare(strict_types=1);

namespace Inside\Workflow\Listeners;

use Inside\Content\Events\ContentPublishedEvent;
use Inside\Workflow\Facades\Proposal;
use Inside\Workflow\Facades\Workflow;

final class ContentPublishedListener
{
    public function handle(ContentPublishedEvent $event): void
    {
        if (! Workflow::isWorkflowEnable() || is_null($event->model->uuid)) {
            return;
        }
        $proposal = Proposal::getFromContent($event->model->uuid, get_class($event->model));

        if (! $proposal) {
            return;
        }
        // Force de-publish if workflow proposal not accepted
        if ($proposal->status !== 1 && $event->model->status !== 0 && ! Proposal::bypassWorkflow($event->model)) {
            Proposal::editContentStatus($event->model, false);
        }
    }
}
