<?php

declare(strict_types=1);

namespace Inside\Workflow\Listeners;

use Inside\Content\Events\ContentDeletedEvent;
use Inside\Workflow\Facades\Proposal;
use Inside\Workflow\Facades\Workflow;

final class ContentDeletedListener
{
    public function handle(ContentDeletedEvent $event): void
    {
        if (! Workflow::isWorkflowEnable() || is_null($event->model)) {
            return;
        }
        $proposal = Proposal::getFromContent($event->model->uuid, $event->model->content_type);
        $proposal?->delete();
    }
}
