<?php

namespace Inside\Workflow\Http\Resources;

use Illuminate\Http\Resources\Json\Resource;
use Inside\Workflow\Models\WorkflowStep;

/**
 * @mixin WorkflowStep
 */
class WorkflowStepResource extends Resource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'step_type' => $this->step_type,
            'title' => $this->title,
            'send_mail' => $this->send_mail,
            'reviewers' => $this->reviewers->map->only(['id', 'name']),
        ];
    }
}
