<?php

namespace Inside\Workflow\Http\Resources;

use Illuminate\Http\Resources\Json\Resource;
use Inside\Content\Models\Contents\Users;
use Inside\Workflow\Facades\Proposal;
use Inside\Workflow\Models\Proposal as ProposalModel;

/**
 * @mixin ProposalModel
 */
class ProposalResource extends Resource
{
    public function toArray($request): array
    {
        $proposable = $this->getProposableModelAttribute();

        if (! $proposable) {
            return [];
        }

        $author = Users::find(Proposal::getContentAuthorUuid($proposable));

        return [
            'title' => $proposable->title,
            'slug' => $proposable->slug,
            'uuid' => $this->proposable_uuid,
            'type' => class_to_type($this->proposable_type),
            'content_type' => class_to_type($this->proposable_type),
            'status' => $this->status,
            'langcode' => $proposable->langcode,
            'created_at' => $proposable->created_at,
            'author' => [
                'uuid' => $author->uuid,
                'image' => $author->image,
                'firstname' => $author->firstname,
                'lastname' => $author->lastname,
            ],
        ];
    }
}
