<?php

namespace Inside\Workflow\Http\Middlewares;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class WorkflowRelatedContentMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        $validator = Validator::make(['id' => $request->route('id'), 'status' => $request->route('status')], [
            'id' => 'required|integer',
            'status' => 'required|in:in-progress,done',
        ]);

        if ($validator->fails()) {
            throw new NotFoundHttpException('Route Not Found !');
        }

        return $next($request);
    }
}
