<?php

declare(strict_types=1);

namespace Inside\Workflow\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use Inside\Workflow\Facades\Workflow;
use Inside\Workflow\Http\Resources\WorkflowResource;
use Laravel\Lumen\Routing\Controller;

class WorkflowController extends Controller
{
    /**
     * @return AnonymousResourceCollection
     */
    public function index()
    {
        $workflows = Workflow::list();

        return WorkflowResource::collection($workflows);
    }

    /**
     * @param Request $request
     * @param int $id
     * @return WorkflowResource
     */
    public function get(Request $request, int $id): WorkflowResource
    {
        $workflow = Workflow::get($id);

        return new WorkflowResource($workflow);
    }

    /**
     * @param Request $request
     * @return WorkflowResource
     */
    public function post(Request $request): WorkflowResource
    {
        $data = $request->only(
            'title',
            'contributors',
            'steps',
            'contents',
            'conditions',
            'notified_roles',
            'send_mail'
        );
        $workflow = Workflow::create($data);

        return new WorkflowResource($workflow);
    }

    /**
     * @param Request $request
     * @param int $id
     * @return WorkflowResource
     */
    public function put(Request $request, int $id): WorkflowResource
    {
        $data = $request->only(
            'title',
            'contributors',
            'steps',
            'notified_roles',
            'send_mail'
        );
        $workflow = Workflow::update($id, $data);

        return new WorkflowResource($workflow);
    }

    /**
     * @param int $id
     * @return array
     */
    public function delete(int $id): array
    {
        Workflow::delete($id);

        return ['data' => null];
    }

    public function getRelatedContents(Request $request, int $id): WorkflowResource
    {
        $workflow = Workflow::get($id);

        return new WorkflowResource($workflow);
    }
}
