<?php

declare(strict_types=1);

namespace Inside\Workflow\Contracts;

use Closure;
use Illuminate\Database\Eloquent\Collection;
use Inside\Workflow\Models\Workflow as WorkflowModel;

interface Workflow
{
    /** @return Collection<WorkflowModel> */
    public function list(): Collection;

    public function get(int $id): ?WorkflowModel;

    public function create(array $data): WorkflowModel;

    public function update(int $id, array $data): ?WorkflowModel;

    public function delete(int $id): void;

    /**
     * @param  array<int, string>|string  $contentTypes
     * @return bool
     */
    public function isContentInWorkflow(array|string $contentTypes): bool;

    public function withoutWorkflow(Closure $callback): mixed;

    public function isWorkflowEnable(): bool;

    public function enableWorkflow(): void;

    public function disableWorkflow(): void;
}
