<?php

declare(strict_types=1);

namespace Inside\Workflow\Content\Revision\Middleware;

use Inside\Content\Models\Content;
use Inside\Workflow\Facades\Proposal;
use Inside\Workflow\Models\Traits\HasWorkflow;

final class Restore
{
    public function __invoke(Content $content, callable $next): bool
    {
        if (! in_array(HasWorkflow::class, class_uses_recursive($content)) || is_null($content->uuid)) {
            return $next($content);
        }
        $proposal = Proposal::getFromContent($content->uuid, get_class($content));
        if (is_null($proposal) || $proposal->status === 1) {
            return $next($content);
        }

        return false;
    }
}
