<?php

namespace Inside\Workflow\Console;

use Illuminate\Support\Collection;
use Inside\Console\Command;
use Inside\Workflow\Models\Proposal;
use Inside\Workflow\Models\ProposalCycle;

class CleanProposalStepsCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'proposal-steps:generate';

    /**
     * @var string
     */
    protected $description = 'Create missing steps for proposals';

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'proposal-steps:generate';

    /**
     * @param Collection $steps
     * @param ProposalCycle $cycle
     * @return void
     */
    protected function handleSteps(Collection $steps, ProposalCycle $cycle): void
    {
        foreach ($steps as $step) {
            if ($cycle->steps->contains('id', $step->id)) {
                continue;
            }
            $cycle->steps()->create([
                'step_id' => $step->id,
            ]);
        }
    }

    /**
     * @inheritDoc
     * @return void
     */
    public function handle()
    {
        Proposal::each(function (Proposal $proposal) {
            $model = $proposal->getProposableModelAttribute();

            if (! $model) {
                $proposal->delete();

                return;
            }

            if ($model->status) {
                $cycles = $proposal->cycles;
                foreach ($cycles as $cycle) {
                    foreach ($cycle->steps as $step) {
                        if (is_null($step->user_uuid) && is_null($step->reviewer_uuid) && empty($step->review) && ! $step->validated) {
                            $cycle->delete();
                            break;
                        }
                    }
                }

                if ($proposal->cycles->count() === 0) {
                    $proposal->delete();
                }

                return;
            }

            $cycles = $proposal->cycles;
            $steps = $proposal->workflow->steps;
            if ($cycles === null || $cycles->isEmpty()) {
                $this->handleSteps($steps, $proposal->cycles()->create());
            } else {
                foreach ($cycles as $cycle) {
                    $this->handleSteps($steps, $cycle);
                }
            }
        });
    }
}
