# Inside Workflow

Inside workflow is responsible for managing workflows. Internaly, it
uses symfony workflow system : https://symfony.com/doc/current/components/workflow.html


## Dump a Workflow

```bash
php artisan workflow:dump moderated --format=graphviz | dot -Tpng -o dot.png
```

## Using workflows

### Get workflow list

| Method | Endpoint | Parameters | Return |
|----|----|----|---|
| GET | /api/v1/workflows | VOID | [] |


This get list of all available workflows for each content type with
current user permissions on transition

Here is the result you get:

```json
{
   "moderated":{
      "type":"workflow",
      "marking_store":{
         "type":"single_state",
         "arguments":[
            "status"
         ]
      },
      "places":{
         "draft":2,
         "review":3,
         "rejected":0,
         "published":1
      },
      "transitions":{
         "to_review":{
            "from":"draft",
            "to":"review"
         },
         "publish":{
            "from":"review",
            "to":"published"
         },
         "reject":{
            "from":"review",
            "to":"rejected"
         }
      },
      "supports":{
         "events":{
            "to_review":[

            ],
            "publish":[

            ],
            "reject":[

            ]
         },
         "news":{
            "to_review":[
                'assistants',
                'moderator'
                'webmaster',
            ],
            "publish":[
                'moderator'
                'webmaster',
            ],
            "reject":[
                'moderator',
                'webmaster',
            ]
         }
      }
   }
}
```

For each workflow, you get its informations

*type*: "workflow" for a workflow or "state_machine" for a finite state machine.
Note: We see here workflow has a particular finite state machine which doesn't allow loops on state and always go forward.

*marking_store*: The marking store is the way we can save/write our state. There are two type of marking store: single_state/multiple_state.
"single_state" allow to save a single state of subject : the subject can only be in one state at a time whereas multiple_state allow to save
multiple state of a subject. You must provide as argument the property which will store the state/states.

*places*: This is the state name and values of the subject.

*transitions*: Transitions are the transition between places.

*supports*: It lists all content type that supports this workflow and for
each one, transitions with roles that are allowed to do the transition.

### Update workflow list

| Method | Endpoint | Parameters | Return |
|----|----|----|---|
| PUT | /api/v1/workflows/{workflowName} | datas | [] |

Waited datas to be put are for example:
```json
[
    "news": {
        "transition1": [role1, role2]
    }
]
```

Note that this endpoint will remove all permissions for this workflow
and replace it with those from data parameter.
