<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Inside\Workflow\Models\Workflow;
use Inside\Workflow\Models\WorkflowStep;

class AddConditionToWorkflowTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasColumn('inside_workflows', 'conditions')) {
            return;
        }

        Schema::table('inside_workflows', function (Blueprint $table) {
            $table->longText('conditions')->after('contents')->nullable();
        });

        $hasOldSystem = Schema::hasColumn('inside_workflows', 'content_categories');

        $workflows = Workflow::all();

        foreach ($workflows as $workflow) {
            $conditions = [];

            $contentCategories = $hasOldSystem ? json_decode($workflow->content_categories, true) : [];

            if (empty($contentCategories)) {
                continue;
            }

            foreach ($contentCategories as $category) {
                $conditionKey = $category['type'].':in';

                $conditions[$conditionKey][] = $category['uuid'];
            }

            DB::table('inside_workflows')->where('id', $workflow->id)->update(['conditions' => json_encode($conditions)]);
        }

        if ($hasOldSystem) {
            Schema::table('inside_workflows', function (Blueprint $table) {
                $table->dropColumn('content_categories');
            });
        }
    }
}
