<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotifiedRolesWorkflowsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::dropIfExists('inside_notified_roles_workflows');
        Schema::create('inside_notified_roles_workflows', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('role_id')->unsigned();
            $table->integer('workflow_id')->unsigned();
            $table->foreign('role_id')
                ->references('id')->on('inside_roles')
                ->onDelete('cascade');
            $table->foreign('workflow_id')
                ->references('id')->on('inside_workflows')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_notified_roles_workflows');
    }
}
