<?php

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Inside\User\Models\User;
use Inside\Workflow\Models\Workflow;

return [
    'bypass_status_scope_callbacks' => [
        function (string $type) {
            /** @var ?User $user */
            $user = Auth::user();
            if ($user === null) {
                return;
            }

            /** @var Collection<Workflow> $workflows */
            $workflows = Workflow::query()->where('active', true)->get();
            foreach ($workflows as $workflow) {
                if (! in_array($type, $workflow->contents)) {
                    continue;
                }

                // contributors
                if ($user->permission->hasAnyRole($workflow->contributors)) {
                    return true;
                }
                foreach ($workflow->steps as $step) {
                    // reviewers
                    if ($user->permission->hasAnyRole($step->reviewers)) {
                        return true;
                    }
                }
            }
        },
    ],
];
