<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => 'Inside\Wall\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->post('walls/subscribe/{wallUuid}', ['uses' => 'WallsController@subscribe']);
        $router->delete('walls/subscribe/{wallUuid}', ['uses' => 'WallsController@unsubscribe']);
        $router->get('walls/subscribe/{wallUuid}', ['uses' => 'WallsController@isSubscribed']);
        $router->get('walls/comments', ['uses' => 'WallsController@getAllComments']);
    }
);
