<?php

namespace Inside\Wall\Providers;

use Illuminate\Support\Facades\Event;
use Inside\Support\EventServiceProvider;
use Inside\Content\Events\CommentCreatedEvent;
use Inside\Wall\Listeners\WallsCommentCreatedListener;
use Inside\Wall\Listeners\WallsListener;
use Inside\Content\Events\ContentInsertedEvent;

/**
 * Wall service provider
 *
 * @category Class
 * @package  Inside\Wall\Providers\WallServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class WallServiceProvider extends EventServiceProvider
{
    protected array $listen =  [
        ContentInsertedEvent::class => [
            WallsListener::class
        ],
        CommentCreatedEvent::class => [
            WallsCommentCreatedListener::class,
        ],
    ];
}
