<?php

namespace Inside\Wall\Listeners;

use Inside\Content\Events\ContentInsertedEvent;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Models\Contents\Walls;
use Inside\Notify\Models\NotificationType;

class WallsListener
{
    /**
     *
     * @param ContentInsertedEvent $event
     */
    public function handle(ContentInsertedEvent $event): void
    {
        if (isset($event->model) && $event->model instanceof Walls) {
            $this->createNotificationsForNewWall($event->model);
        }
    }

    public function createNotificationsForNewWall(Walls $wall): void
    {
        /** @var NotificationType $notificationType */
        $notificationType = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\CommentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'contentCommented',
                'type' => 'global',
                'condition' => 'walls:'.$wall->uuid,
                'multiple' => false,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.comment.content.title',
                    'description' => 'notifications.create.comment.content.description',
                    'icon' => 'comment',
                    'text' => 'notifications.create.comment.content.<content_type>.text',
                    'fields' => [
                        'title',
                        'content_type',
                    ],
                ],
            ]
        );

        $users = Users::query()
            ->where('status', 1)
            ->where('langcode', $wall->langcode)
            ->pluck('uuid');

        $notificationType->subscribers()->syncWithoutDetaching($users);
    }
}
