<?php

namespace Inside\Wall\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\CommentCreatedEvent;
use Inside\Content\Models\Contents\Comments;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;
use Illuminate\Support\Facades\Log;

class WallsCommentCreatedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(CommentCreatedEvent $event): void
    {
        if ($event->comment->content_type != 'comments') {
            return;
        }

        $comment = $event->comment;
        $scrollComment = $comment;
        $model = $parent = null;
        $parents = $comment->getParentsIfExist();
        foreach ($parents as $content_type => $contentParents) {
            if ($content_type != 'comments' && !empty($contentParents)) {
                $parent = $model = array_first($contentParents);
                break;
            }
        }

        if ($parent->content_type !== 'walls') {
            return;
        }

        /** @var NotificationType $type */
        $type = NotificationType::query()
            ->where('condition', 'walls:' . $parent->uuid)
            ->where('action', 'contentCommented')
            ->first();


        if ($type->action !== 'contentCommented') {
            return;
        }

        $notificationData = [
            'from' => $comment->author,
            'comment' => $comment,
            'parentComment' => $scrollComment,
            'url' => ($model->slug[0] ?? '').'#&d/'.$scrollComment->uuid,
        ];

        $type->subscribers->each(
            function ($subscriber) use ($type, $comment, $parent, $model, $notificationData) {
                if ($subscriber->uuid === $comment->author) {
                    return;
                }
                $this->route = $subscriber;

                if ($parent && $model) {
                    $roles = $type->role ? $type->roles->pluck('name')->toArray() : [];
                    $this->notify(
                        $type,
                        $subscriber,
                        $model,
                        $notificationData,
                        $roles
                    );
                }
            }
        );
    }
}
