<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;
use Inside\Content\Models\Content;

class CreateCustomPageWalls extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        $wallsLanguages = collect([
            'fr' => 'Murs de discussion',
            'en' => 'Discussion Walls',
            'es' => 'Muros de discusión',
            'pt' => 'Paredes de discussão',
            'de' => 'Diskussionswände',
            'nl' => 'Discussiewanden',
        ])->only(list_languages());

        $parent_uuid_host = null;

        $wallsLanguages->each(function ($title, $lang) use ($bridge, $parent_uuid_host) {
            $wallsCustomPageExists = type_to_class('custom')::query()->where('custom_slug', 'walls')->where('langcode', $lang)->exists();

            if (is_null($parent_uuid_host) && $wallsCustomPageExists instanceof Content) {
                $parent_uuid_host = $wallsCustomPageExists->uuid;
            }

            if ($wallsCustomPageExists) {
                return;
            }

            $data = collect([
                'langcode' => $lang,
                'title' => $title,
                'custom_slug' => 'walls',
                'redirection_page' => 'WallsListingPage',
                'uuid_host' => $parent_uuid_host,
            ])->when(is_null($parent_uuid_host), fn ($data) => $data->forget('uuid_host'));

            $uuid_host = $bridge->contentInsert(
                type: 'custom',
                data: $data->toArray(),
            );

            if (is_null($parent_uuid_host)) {
                $firstCustomPage = $uuid_host;
            }

            Log::info("Custom page 'walls' inserted for language: $lang");
        });
    }
}
